@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.kotlin.outputs.CustomPluginLocation
import com.pulumi.aws.mskconnect.kotlin.outputs.CustomPluginLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomPlugin].
 */
@PulumiTagMarker
public class CustomPluginResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomPluginArgs = CustomPluginArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomPluginArgsBuilder.() -> Unit) {
        val builder = CustomPluginArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomPlugin {
        val builtJavaResource = com.pulumi.aws.mskconnect.CustomPlugin(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomPlugin(builtJavaResource)
    }
}

/**
 * Provides an Amazon MSK Connect Custom Plugin Resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.mskconnect.CustomPlugin;
 * import com.pulumi.aws.mskconnect.CustomPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("debezium.zip")
 *             .source(new FileAsset("debezium.zip"))
 *             .build());
 *         var exampleCustomPlugin = new CustomPlugin("exampleCustomPlugin", CustomPluginArgs.builder()
 *             .contentType("ZIP")
 *             .location(CustomPluginLocationArgs.builder()
 *                 .s3(CustomPluginLocationS3Args.builder()
 *                     .bucketArn(exampleBucketV2.arn())
 *                     .fileKey(exampleBucketObjectv2.key())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK Connect Custom Plugin using the plugin's `arn`. For example:
 * ```sh
 *  $ pulumi import aws:mskconnect/customPlugin:CustomPlugin example 'arn:aws:kafkaconnect:eu-central-1:123456789012:custom-plugin/debezium-example/abcdefgh-1234-5678-9abc-defghijklmno-4'
 * ```
 *
 */
public class CustomPlugin internal constructor(
    override val javaResource: com.pulumi.aws.mskconnect.CustomPlugin,
) : KotlinCustomResource(javaResource, CustomPluginMapper) {
    /**
     * the Amazon Resource Name (ARN) of the custom plugin.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * A summary description of the custom plugin.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * an ID of the latest successfully created revision of the custom plugin.
     */
    public val latestRevision: Output<Int>
        get() = javaResource.latestRevision().applyValue({ args0 -> args0 })

    /**
     * Information about the location of a custom plugin. See below.
     * The following arguments are optional:
     */
    public val location: Output<CustomPluginLocation>
        get() = javaResource.location().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the custom plugin..
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the state of the custom plugin.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object CustomPluginMapper : ResourceMapper<CustomPlugin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mskconnect.CustomPlugin::class == javaResource::class

    override fun map(javaResource: Resource): CustomPlugin = CustomPlugin(
        javaResource as
            com.pulumi.aws.mskconnect.CustomPlugin,
    )
}

/**
 * @see [CustomPlugin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomPlugin].
 */
public suspend fun customPlugin(
    name: String,
    block: suspend CustomPluginResourceBuilder.() -> Unit,
): CustomPlugin {
    val builder = CustomPluginResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomPlugin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customPlugin(name: String): CustomPlugin {
    val builder = CustomPluginResourceBuilder()
    builder.name(name)
    return builder.build()
}
