@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.CustomPluginArgs.builder
import com.pulumi.aws.mskconnect.kotlin.inputs.CustomPluginLocationArgs
import com.pulumi.aws.mskconnect.kotlin.inputs.CustomPluginLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Custom Plugin Resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.mskconnect.CustomPlugin;
 * import com.pulumi.aws.mskconnect.CustomPluginArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs;
 * import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationS3Args;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("debezium.zip")
 *             .source(new FileAsset("debezium.zip"))
 *             .build());
 *         var exampleCustomPlugin = new CustomPlugin("exampleCustomPlugin", CustomPluginArgs.builder()
 *             .contentType("ZIP")
 *             .location(CustomPluginLocationArgs.builder()
 *                 .s3(CustomPluginLocationS3Args.builder()
 *                     .bucketArn(exampleBucketV2.arn())
 *                     .fileKey(exampleBucketObjectv2.key())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK Connect Custom Plugin using the plugin's `arn`. For example:
 * ```sh
 *  $ pulumi import aws:mskconnect/customPlugin:CustomPlugin example 'arn:aws:kafkaconnect:eu-central-1:123456789012:custom-plugin/debezium-example/abcdefgh-1234-5678-9abc-defghijklmno-4'
 * ```
 * @property contentType The type of the plugin file. Allowed values are `ZIP` and `JAR`.
 * @property description A summary description of the custom plugin.
 * @property location Information about the location of a custom plugin. See below.
 * The following arguments are optional:
 * @property name The name of the custom plugin..
 */
public data class CustomPluginArgs(
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<CustomPluginLocationArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.CustomPluginArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.CustomPluginArgs =
        com.pulumi.aws.mskconnect.CustomPluginArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomPluginArgs].
 */
@PulumiTagMarker
public class CustomPluginArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<CustomPluginLocationArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    @JvmName("lunwqyflvsegllhl")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value A summary description of the custom plugin.
     */
    @JvmName("sbccckbsmyeumjvp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the location of a custom plugin. See below.
     * The following arguments are optional:
     */
    @JvmName("yqyktgknwsxtnwwp")
    public suspend fun location(`value`: Output<CustomPluginLocationArgs>) {
        this.location = value
    }

    /**
     * @param value The name of the custom plugin..
     */
    @JvmName("sbaopxrnljceeocj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the plugin file. Allowed values are `ZIP` and `JAR`.
     */
    @JvmName("bvxjbqlhbnuvyqlg")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value A summary description of the custom plugin.
     */
    @JvmName("vluqmbawernxihcy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the location of a custom plugin. See below.
     * The following arguments are optional:
     */
    @JvmName("kwdnpjxxcfpuutin")
    public suspend fun location(`value`: CustomPluginLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument Information about the location of a custom plugin. See below.
     * The following arguments are optional:
     */
    @JvmName("ovdbqavftcukjjhd")
    public suspend fun location(argument: suspend CustomPluginLocationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomPluginLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value The name of the custom plugin..
     */
    @JvmName("fsjwejjwnoqturxp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CustomPluginArgs = CustomPluginArgs(
        contentType = contentType,
        description = description,
        location = location,
        name = name,
    )
}
