@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin

import com.pulumi.aws.mskconnect.WorkerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon MSK Connect Worker Configuration Resource.
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mskconnect.WorkerConfiguration;
 * import com.pulumi.aws.mskconnect.WorkerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkerConfiguration("example", WorkerConfigurationArgs.builder()
 *             .propertiesFileContent("""
 * key.converter=org.apache.kafka.connect.storage.StringConverter
 * value.converter=org.apache.kafka.connect.storage.StringConverter
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MSK Connect Worker Configuration using the plugin's `arn`. For example:
 * ```sh
 *  $ pulumi import aws:mskconnect/workerConfiguration:WorkerConfiguration example 'arn:aws:kafkaconnect:eu-central-1:123456789012:worker-configuration/example/8848493b-7fcc-478c-a646-4a52634e3378-4'
 * ```
 * @property description A summary description of the worker configuration.
 * @property name The name of the worker configuration.
 * @property propertiesFileContent Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
 * The following arguments are optional:
 */
public data class WorkerConfigurationArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val propertiesFileContent: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.WorkerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.WorkerConfigurationArgs =
        com.pulumi.aws.mskconnect.WorkerConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .propertiesFileContent(propertiesFileContent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkerConfigurationArgs].
 */
@PulumiTagMarker
public class WorkerConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var propertiesFileContent: Output<String>? = null

    /**
     * @param value A summary description of the worker configuration.
     */
    @JvmName("bhaocrlrosxmsiol")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the worker configuration.
     */
    @JvmName("baeagwjiqjvoedgf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
     * The following arguments are optional:
     */
    @JvmName("ketdcewwqmxscdpf")
    public suspend fun propertiesFileContent(`value`: Output<String>) {
        this.propertiesFileContent = value
    }

    /**
     * @param value A summary description of the worker configuration.
     */
    @JvmName("gnfxeijrhyjidrmc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the worker configuration.
     */
    @JvmName("wsavpsyakeamtkte")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Contents of connect-distributed.properties file. The value can be either base64 encoded or in raw format.
     * The following arguments are optional:
     */
    @JvmName("soibtsglolotmufq")
    public suspend fun propertiesFileContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertiesFileContent = mapped
    }

    internal fun build(): WorkerConfigurationArgs = WorkerConfigurationArgs(
        description = description,
        name = name,
        propertiesFileContent = propertiesFileContent,
    )
}
