@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoscaling Information about the auto scaling parameters for the connector. See below.
 * @property provisionedCapacity Details about a fixed capacity allocated to a connector. See below.
 */
public data class ConnectorCapacityArgs(
    public val autoscaling: Output<ConnectorCapacityAutoscalingArgs>? = null,
    public val provisionedCapacity: Output<ConnectorCapacityProvisionedCapacityArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityArgs.builder()
            .autoscaling(autoscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisionedCapacity(
                provisionedCapacity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorCapacityArgs].
 */
@PulumiTagMarker
public class ConnectorCapacityArgsBuilder internal constructor() {
    private var autoscaling: Output<ConnectorCapacityAutoscalingArgs>? = null

    private var provisionedCapacity: Output<ConnectorCapacityProvisionedCapacityArgs>? = null

    /**
     * @param value Information about the auto scaling parameters for the connector. See below.
     */
    @JvmName("pdyacrjpngeqfgpb")
    public suspend fun autoscaling(`value`: Output<ConnectorCapacityAutoscalingArgs>) {
        this.autoscaling = value
    }

    /**
     * @param value Details about a fixed capacity allocated to a connector. See below.
     */
    @JvmName("tiomdyruhjppkqlf")
    public suspend
    fun provisionedCapacity(`value`: Output<ConnectorCapacityProvisionedCapacityArgs>) {
        this.provisionedCapacity = value
    }

    /**
     * @param value Information about the auto scaling parameters for the connector. See below.
     */
    @JvmName("eacesilkpbioscqf")
    public suspend fun autoscaling(`value`: ConnectorCapacityAutoscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaling = mapped
    }

    /**
     * @param argument Information about the auto scaling parameters for the connector. See below.
     */
    @JvmName("fflytjdxuhhraxls")
    public suspend
    fun autoscaling(argument: suspend ConnectorCapacityAutoscalingArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityAutoscalingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoscaling = mapped
    }

    /**
     * @param value Details about a fixed capacity allocated to a connector. See below.
     */
    @JvmName("eojkrgaktmmrfxri")
    public suspend fun provisionedCapacity(`value`: ConnectorCapacityProvisionedCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedCapacity = mapped
    }

    /**
     * @param argument Details about a fixed capacity allocated to a connector. See below.
     */
    @JvmName("caodnfbdixisxysp")
    public suspend
    fun provisionedCapacity(argument: suspend ConnectorCapacityProvisionedCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorCapacityProvisionedCapacityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.provisionedCapacity = mapped
    }

    internal fun build(): ConnectorCapacityArgs = ConnectorCapacityArgs(
        autoscaling = autoscaling,
        provisionedCapacity = provisionedCapacity,
    )
}
