@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpuUtilizationPercentage The CPU utilization percentage threshold at which you want connector scale out to be triggered.
 */
public data class ConnectorCapacityAutoscalingScaleOutPolicyArgs(
    public val cpuUtilizationPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs> {
    override fun toJava():
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorCapacityAutoscalingScaleOutPolicyArgs.builder()
            .cpuUtilizationPercentage(cpuUtilizationPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorCapacityAutoscalingScaleOutPolicyArgs].
 */
@PulumiTagMarker
public class ConnectorCapacityAutoscalingScaleOutPolicyArgsBuilder internal constructor() {
    private var cpuUtilizationPercentage: Output<Int>? = null

    /**
     * @param value The CPU utilization percentage threshold at which you want connector scale out to be triggered.
     */
    @JvmName("lehwonhcaluotdnh")
    public suspend fun cpuUtilizationPercentage(`value`: Output<Int>) {
        this.cpuUtilizationPercentage = value
    }

    /**
     * @param value The CPU utilization percentage threshold at which you want connector scale out to be triggered.
     */
    @JvmName("yhfkwnuqimqojqhu")
    public suspend fun cpuUtilizationPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuUtilizationPercentage = mapped
    }

    internal fun build(): ConnectorCapacityAutoscalingScaleOutPolicyArgs =
        ConnectorCapacityAutoscalingScaleOutPolicyArgs(
            cpuUtilizationPercentage = cpuUtilizationPercentage,
        )
}
