@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bootstrapServers The bootstrap servers of the cluster.
 * @property vpc Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
 */
public data class ConnectorKafkaClusterApacheKafkaClusterArgs(
    public val bootstrapServers: Output<String>,
    public val vpc: Output<ConnectorKafkaClusterApacheKafkaClusterVpcArgs>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs> {
    override fun toJava():
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterArgs.builder()
            .bootstrapServers(bootstrapServers.applyValue({ args0 -> args0 }))
            .vpc(vpc.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorKafkaClusterApacheKafkaClusterArgs].
 */
@PulumiTagMarker
public class ConnectorKafkaClusterApacheKafkaClusterArgsBuilder internal constructor() {
    private var bootstrapServers: Output<String>? = null

    private var vpc: Output<ConnectorKafkaClusterApacheKafkaClusterVpcArgs>? = null

    /**
     * @param value The bootstrap servers of the cluster.
     */
    @JvmName("ifjckhinkgjvdqho")
    public suspend fun bootstrapServers(`value`: Output<String>) {
        this.bootstrapServers = value
    }

    /**
     * @param value Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("asaakbmpsijfuohp")
    public suspend fun vpc(`value`: Output<ConnectorKafkaClusterApacheKafkaClusterVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value The bootstrap servers of the cluster.
     */
    @JvmName("dquvnifbkjhrlvdc")
    public suspend fun bootstrapServers(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootstrapServers = mapped
    }

    /**
     * @param value Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("wmxeadvlduircykc")
    public suspend fun vpc(`value`: ConnectorKafkaClusterApacheKafkaClusterVpcArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    @JvmName("cynuaeqtlnxngewk")
    public suspend
    fun vpc(argument: suspend ConnectorKafkaClusterApacheKafkaClusterVpcArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorKafkaClusterApacheKafkaClusterVpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): ConnectorKafkaClusterApacheKafkaClusterArgs =
        ConnectorKafkaClusterApacheKafkaClusterArgs(
            bootstrapServers = bootstrapServers ?: throw PulumiNullFieldException("bootstrapServers"),
            vpc = vpc ?: throw PulumiNullFieldException("vpc"),
        )
}
