@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroups The security groups for the connector.
 * @property subnets The subnets for the connector.
 */
public data class ConnectorKafkaClusterApacheKafkaClusterVpcArgs(
    public val securityGroups: Output<List<String>>,
    public val subnets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs> {
    override fun toJava():
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorKafkaClusterApacheKafkaClusterVpcArgs.builder()
            .securityGroups(securityGroups.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConnectorKafkaClusterApacheKafkaClusterVpcArgs].
 */
@PulumiTagMarker
public class ConnectorKafkaClusterApacheKafkaClusterVpcArgsBuilder internal constructor() {
    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value The security groups for the connector.
     */
    @JvmName("fuhxkjhxtasyhual")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("tygrsltbieshaida")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups for the connector.
     */
    @JvmName("dvtggebjbbogwdds")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The subnets for the connector.
     */
    @JvmName("ocnrkonpctalftkm")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("idsbkknawiwdgdri")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The subnets for the connector.
     */
    @JvmName("rvqciguxgrylhfqh")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The security groups for the connector.
     */
    @JvmName("bsddigbngybxxlet")
    public suspend fun securityGroups(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups for the connector.
     */
    @JvmName("vlgbpmdpaysmqxoc")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The subnets for the connector.
     */
    @JvmName("gcsicvqxkacbbiie")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values The subnets for the connector.
     */
    @JvmName("ytuxosancthwwmpk")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): ConnectorKafkaClusterApacheKafkaClusterVpcArgs =
        ConnectorKafkaClusterApacheKafkaClusterVpcArgs(
            securityGroups = securityGroups ?: throw PulumiNullFieldException("securityGroups"),
            subnets = subnets ?: throw PulumiNullFieldException("subnets"),
        )
}
