@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property workerLogDelivery The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
 */
public data class ConnectorLogDeliveryArgs(
    public val workerLogDelivery: Output<ConnectorLogDeliveryWorkerLogDeliveryArgs>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryArgs.builder()
            .workerLogDelivery(
                workerLogDelivery.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorLogDeliveryArgs].
 */
@PulumiTagMarker
public class ConnectorLogDeliveryArgsBuilder internal constructor() {
    private var workerLogDelivery: Output<ConnectorLogDeliveryWorkerLogDeliveryArgs>? = null

    /**
     * @param value The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
     */
    @JvmName("vxumqdwkntexsytr")
    public suspend fun workerLogDelivery(`value`: Output<ConnectorLogDeliveryWorkerLogDeliveryArgs>) {
        this.workerLogDelivery = value
    }

    /**
     * @param value The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
     */
    @JvmName("qspbqntngwhgrksl")
    public suspend fun workerLogDelivery(`value`: ConnectorLogDeliveryWorkerLogDeliveryArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerLogDelivery = mapped
    }

    /**
     * @param argument The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
     */
    @JvmName("onkfkbohsguegeqx")
    public suspend
    fun workerLogDelivery(argument: suspend ConnectorLogDeliveryWorkerLogDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryWorkerLogDeliveryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workerLogDelivery = mapped
    }

    internal fun build(): ConnectorLogDeliveryArgs = ConnectorLogDeliveryArgs(
        workerLogDelivery = workerLogDelivery ?: throw PulumiNullFieldException("workerLogDelivery"),
    )
}
