@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs Details about delivering logs to Amazon CloudWatch Logs. See below.
 * @property firehose Details about delivering logs to Amazon Kinesis Data Firehose. See below.
 * @property s3 Details about delivering logs to Amazon S3. See below.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryArgs(
    public val cloudwatchLogs: Output<ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs>? =
        null,
    public val firehose: Output<ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs>? = null,
    public val s3: Output<ConnectorLogDeliveryWorkerLogDeliveryS3Args>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehose(firehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorLogDeliveryWorkerLogDeliveryArgs].
 */
@PulumiTagMarker
public class ConnectorLogDeliveryWorkerLogDeliveryArgsBuilder internal constructor() {
    private var cloudwatchLogs: Output<ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs>? =
        null

    private var firehose: Output<ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs>? = null

    private var s3: Output<ConnectorLogDeliveryWorkerLogDeliveryS3Args>? = null

    /**
     * @param value Details about delivering logs to Amazon CloudWatch Logs. See below.
     */
    @JvmName("cydowswnbggspwmr")
    public suspend
    fun cloudwatchLogs(`value`: Output<ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value Details about delivering logs to Amazon Kinesis Data Firehose. See below.
     */
    @JvmName("jrxpfxbbirakflqf")
    public suspend fun firehose(`value`: Output<ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs>) {
        this.firehose = value
    }

    /**
     * @param value Details about delivering logs to Amazon S3. See below.
     */
    @JvmName("hxjxnswvdpvqbalt")
    public suspend fun s3(`value`: Output<ConnectorLogDeliveryWorkerLogDeliveryS3Args>) {
        this.s3 = value
    }

    /**
     * @param value Details about delivering logs to Amazon CloudWatch Logs. See below.
     */
    @JvmName("vhdcwuwqeojculdg")
    public suspend
    fun cloudwatchLogs(`value`: ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument Details about delivering logs to Amazon CloudWatch Logs. See below.
     */
    @JvmName("rihdifyqcrvmidnc")
    public suspend
    fun cloudwatchLogs(argument: suspend ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value Details about delivering logs to Amazon Kinesis Data Firehose. See below.
     */
    @JvmName("xdrsfbsxnpytixis")
    public suspend fun firehose(`value`: ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehose = mapped
    }

    /**
     * @param argument Details about delivering logs to Amazon Kinesis Data Firehose. See below.
     */
    @JvmName("roelgnwefgooodsk")
    public suspend
    fun firehose(argument: suspend ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.firehose = mapped
    }

    /**
     * @param value Details about delivering logs to Amazon S3. See below.
     */
    @JvmName("rkvmtjxgjbotkgvg")
    public suspend fun s3(`value`: ConnectorLogDeliveryWorkerLogDeliveryS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Details about delivering logs to Amazon S3. See below.
     */
    @JvmName("iuqujmjuaetewnvp")
    public suspend
    fun s3(argument: suspend ConnectorLogDeliveryWorkerLogDeliveryS3ArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorLogDeliveryWorkerLogDeliveryS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): ConnectorLogDeliveryWorkerLogDeliveryArgs =
        ConnectorLogDeliveryWorkerLogDeliveryArgs(
            cloudwatchLogs = cloudwatchLogs,
            firehose = firehose,
            s3 = s3,
        )
}
