@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether log delivery to Amazon CloudWatch Logs is enabled.
 * @property logGroup The name of the CloudWatch log group that is the destination for log delivery.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs(
    public val enabled: Output<Boolean>,
    public val logGroup: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs> {
    override fun toJava():
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs =
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .logGroup(logGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroup: Output<String>? = null

    /**
     * @param value Whether log delivery to Amazon CloudWatch Logs is enabled.
     */
    @JvmName("mbwfuwbnplwekgjw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the CloudWatch log group that is the destination for log delivery.
     */
    @JvmName("incetrnswdglsahk")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value Whether log delivery to Amazon CloudWatch Logs is enabled.
     */
    @JvmName("vwlrsrlnadmycnpj")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the CloudWatch log group that is the destination for log delivery.
     */
    @JvmName("ynjsopnfilhvdino")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    internal fun build(): ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs =
        ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            logGroup = logGroup,
        )
}
