@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The name of the S3 bucket that is the destination for log delivery.
 * @property enabled Whether log delivery to Amazon CloudWatch Logs is enabled.
 * @property prefix The S3 prefix that is the destination for log delivery.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryS3Args(
    public val bucket: Output<String>? = null,
    public val enabled: Output<Boolean>,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryS3Args> {
    override fun toJava():
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryS3Args =
        com.pulumi.aws.mskconnect.inputs.ConnectorLogDeliveryWorkerLogDeliveryS3Args.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorLogDeliveryWorkerLogDeliveryS3Args].
 */
@PulumiTagMarker
public class ConnectorLogDeliveryWorkerLogDeliveryS3ArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The name of the S3 bucket that is the destination for log delivery.
     */
    @JvmName("nbyqmgtynilvohrp")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Whether log delivery to Amazon CloudWatch Logs is enabled.
     */
    @JvmName("hqxuitchrxpowqiq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The S3 prefix that is the destination for log delivery.
     */
    @JvmName("yairubjpmapwhcdp")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the S3 bucket that is the destination for log delivery.
     */
    @JvmName("uowolxglmbwfndqh")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Whether log delivery to Amazon CloudWatch Logs is enabled.
     */
    @JvmName("vgppklbyrpiegnbq")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The S3 prefix that is the destination for log delivery.
     */
    @JvmName("ksrkemmqvopwlqpu")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ConnectorLogDeliveryWorkerLogDeliveryS3Args =
        ConnectorLogDeliveryWorkerLogDeliveryS3Args(
            bucket = bucket,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            prefix = prefix,
        )
}
