@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3 Information of the plugin file stored in Amazon S3. See below.
 */
public data class CustomPluginLocationArgs(
    public val s3: Output<CustomPluginLocationS3Args>,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs =
        com.pulumi.aws.mskconnect.inputs.CustomPluginLocationArgs.builder()
            .s3(s3.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomPluginLocationArgs].
 */
@PulumiTagMarker
public class CustomPluginLocationArgsBuilder internal constructor() {
    private var s3: Output<CustomPluginLocationS3Args>? = null

    /**
     * @param value Information of the plugin file stored in Amazon S3. See below.
     */
    @JvmName("hhanvxsqidgxylta")
    public suspend fun s3(`value`: Output<CustomPluginLocationS3Args>) {
        this.s3 = value
    }

    /**
     * @param value Information of the plugin file stored in Amazon S3. See below.
     */
    @JvmName("kesxgofflcmpfshu")
    public suspend fun s3(`value`: CustomPluginLocationS3Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Information of the plugin file stored in Amazon S3. See below.
     */
    @JvmName("qrpkutsiqwqnxaev")
    public suspend fun s3(argument: suspend CustomPluginLocationS3ArgsBuilder.() -> Unit) {
        val toBeMapped = CustomPluginLocationS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): CustomPluginLocationArgs = CustomPluginLocationArgs(
        s3 = s3 ?: throw PulumiNullFieldException("s3"),
    )
}
