@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.GetConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnector.
 * @property name Name of the connector.
 */
public data class GetConnectorPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.GetConnectorPlainArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.GetConnectorPlainArgs =
        com.pulumi.aws.mskconnect.inputs.GetConnectorPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the connector.
     */
    @JvmName("ngadebsjuffavmxl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetConnectorPlainArgs = GetConnectorPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
