@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.GetCustomPluginPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomPlugin.
 * @property name Name of the custom plugin.
 */
public data class GetCustomPluginPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.GetCustomPluginPlainArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.GetCustomPluginPlainArgs =
        com.pulumi.aws.mskconnect.inputs.GetCustomPluginPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomPluginPlainArgs].
 */
@PulumiTagMarker
public class GetCustomPluginPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the custom plugin.
     */
    @JvmName("tqrsxrmbspgeitdc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetCustomPluginPlainArgs = GetCustomPluginPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
