@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.inputs

import com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkerConfiguration.
 * @property name Name of the worker configuration.
 */
public data class GetWorkerConfigurationPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs =
        com.pulumi.aws.mskconnect.inputs.GetWorkerConfigurationPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetWorkerConfigurationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the worker configuration.
     */
    @JvmName("gfsglxnuokdmlihp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetWorkerConfigurationPlainArgs = GetWorkerConfigurationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
