@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudwatchLogs Details about delivering logs to Amazon CloudWatch Logs. See below.
 * @property firehose Details about delivering logs to Amazon Kinesis Data Firehose. See below.
 * @property s3 Details about delivering logs to Amazon S3. See below.
 */
public data class ConnectorLogDeliveryWorkerLogDelivery(
    public val cloudwatchLogs: ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs? = null,
    public val firehose: ConnectorLogDeliveryWorkerLogDeliveryFirehose? = null,
    public val s3: ConnectorLogDeliveryWorkerLogDeliveryS3? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorLogDeliveryWorkerLogDelivery):
            ConnectorLogDeliveryWorkerLogDelivery = ConnectorLogDeliveryWorkerLogDelivery(
            cloudwatchLogs = javaType.cloudwatchLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firehose = javaType.firehose().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDeliveryWorkerLogDeliveryFirehose.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3 = javaType.s3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mskconnect.kotlin.outputs.ConnectorLogDeliveryWorkerLogDeliveryS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
