@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deliveryStream The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
 * @property enabled Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
 */
public data class ConnectorLogDeliveryWorkerLogDeliveryFirehose(
    public val deliveryStream: String? = null,
    public val enabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorLogDeliveryWorkerLogDeliveryFirehose):
            ConnectorLogDeliveryWorkerLogDeliveryFirehose =
            ConnectorLogDeliveryWorkerLogDeliveryFirehose(
                deliveryStream = javaType.deliveryStream().map({ args0 -> args0 }).orElse(null),
                enabled = javaType.enabled(),
            )
    }
}
