@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the custom plugin.
 * @property revision The revision of the custom plugin.
 */
public data class ConnectorPluginCustomPlugin(
    public val arn: String,
    public val revision: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.ConnectorPluginCustomPlugin):
            ConnectorPluginCustomPlugin = ConnectorPluginCustomPlugin(
            arn = javaType.arn(),
            revision = javaType.revision(),
        )
    }
}
