@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketArn The Amazon Resource Name (ARN) of an S3 bucket.
 * @property fileKey The file key for an object in an S3 bucket.
 * @property objectVersion The version of an object in an S3 bucket.
 */
public data class CustomPluginLocationS3(
    public val bucketArn: String,
    public val fileKey: String,
    public val objectVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.CustomPluginLocationS3):
            CustomPluginLocationS3 = CustomPluginLocationS3(
            bucketArn = javaType.bucketArn(),
            fileKey = javaType.fileKey(),
            objectVersion = javaType.objectVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
