@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mskconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getConnector.
 * @property arn ARN of the connector.
 * @property description Summary description of the connector.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property version Current version of the connector.
 */
public data class GetConnectorResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mskconnect.outputs.GetConnectorResult):
            GetConnectorResult = GetConnectorResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
