@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createdAt The Created At date of the MWAA Environment
 * * `logging_configuration[0]&#46;<LOG_CONFIGURATION_TYPE>[0].cloud_watch_log_group_arn` - Provides the ARN for the CloudWatch group where the logs will be published
 * @property errors
 * @property status The status of the Amazon MWAA Environment
 */
public data class EnvironmentLastUpdated(
    public val createdAt: String? = null,
    public val errors: List<EnvironmentLastUpdatedError>? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mwaa.outputs.EnvironmentLastUpdated):
            EnvironmentLastUpdated = EnvironmentLastUpdated(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.mwaa.kotlin.outputs.EnvironmentLastUpdatedError.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
