@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mwaa.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Security groups IDs for the environment. At least one of the security group needs to allow MWAA resources to talk to each other, otherwise MWAA cannot be provisioned.
 * @property subnetIds The private subnet IDs in which the environment should be created. MWAA requires two subnets.
 */
public data class EnvironmentNetworkConfiguration(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mwaa.outputs.EnvironmentNetworkConfiguration):
            EnvironmentNetworkConfiguration = EnvironmentNetworkConfiguration(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
