@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.kotlin.outputs.ClusterServerlessV2ScalingConfiguration
import com.pulumi.aws.neptune.kotlin.outputs.ClusterServerlessV2ScalingConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.neptune.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides an Neptune Cluster Resource. A Cluster Resource defines attributes that are
 * applied to the entire cluster of Neptune Cluster Instances.
 * Changes to a Neptune Cluster can occur when you manually change a
 * parameter, such as `backup_retention_period`, and are reflected in the next maintenance
 * window. Because of this, this provider may report a difference in its planning
 * phase because a modification has not yet taken place. You can use the
 * `apply_immediately` flag to instruct the service to apply the change immediately
 * (see documentation below).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .applyImmediately(true)
 *             .backupRetentionPeriod(5)
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .iamDatabaseAuthenticationEnabled(true)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster` using the cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:neptune/cluster:Cluster example my-cluster
 * ```
 *
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.neptune.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
     */
    public val allowMajorVersionUpgrade: Output<Boolean>
        get() = javaResource.allowMajorVersionUpgrade().applyValue({ args0 -> args0 })

    /**
     * Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    public val applyImmediately: Output<Boolean>
        get() = javaResource.applyImmediately().applyValue({ args0 -> args0 })

    /**
     * The Neptune Cluster Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The days to retain backups for. Default `1`
     */
    public val backupRetentionPeriod: Output<Int>?
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    public val clusterIdentifierPrefix: Output<String>
        get() = javaResource.clusterIdentifierPrefix().applyValue({ args0 -> args0 })

    /**
     * List of Neptune Instances that are a part of this cluster
     */
    public val clusterMembers: Output<List<String>>
        get() = javaResource.clusterMembers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Neptune Cluster Resource ID
     */
    public val clusterResourceId: Output<String>
        get() = javaResource.clusterResourceId().applyValue({ args0 -> args0 })

    /**
     * If set to true, tags are copied to any snapshot of the DB cluster that is created.
     */
    public val copyTagsToSnapshot: Output<Boolean>?
        get() = javaResource.copyTagsToSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    public val enableCloudwatchLogsExports: Output<List<String>>?
        get() = javaResource.enableCloudwatchLogsExports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The DNS address of the Neptune instance
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
     */
    public val engine: Output<String>?
        get() = javaResource.engine().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The database engine version.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
     */
    public val finalSnapshotIdentifier: Output<String>?
        get() = javaResource.finalSnapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The global cluster identifier specified on `aws.neptune.GlobalCluster`.
     */
    public val globalClusterIdentifier: Output<String>?
        get() = javaResource.globalClusterIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Route53 Hosted Zone ID of the endpoint
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: Output<Boolean>?
        get() = javaResource.iamDatabaseAuthenticationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    public val iamRoles: Output<List<String>>?
        get() = javaResource.iamRoles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * A cluster parameter group to associate with the cluster.
     */
    public val neptuneClusterParameterGroupName: Output<String>?
        get() = javaResource.neptuneClusterParameterGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     */
    public val neptuneInstanceParameterGroupName: Output<String>?
        get() = javaResource.neptuneInstanceParameterGroupName().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A Neptune subnet group to associate with this Neptune instance.
     */
    public val neptuneSubnetGroupName: Output<String>
        get() = javaResource.neptuneSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * The port on which the Neptune accepts connections. Default is `8182`.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    public val preferredBackupWindow: Output<String>
        get() = javaResource.preferredBackupWindow().applyValue({ args0 -> args0 })

    /**
     * The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * A read-only endpoint for the Neptune cluster, automatically load-balanced across replicas
     */
    public val readerEndpoint: Output<String>
        get() = javaResource.readerEndpoint().applyValue({ args0 -> args0 })

    /**
     * ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
     */
    public val replicationSourceIdentifier: Output<String>?
        get() = javaResource.replicationSourceIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    public val serverlessV2ScalingConfiguration: Output<ClusterServerlessV2ScalingConfiguration>?
        get() = javaResource.serverlessV2ScalingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    public val skipFinalSnapshot: Output<Boolean>?
        get() = javaResource.skipFinalSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    public val snapshotIdentifier: Output<String>?
        get() = javaResource.snapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
     */
    public val storageEncrypted: Output<Boolean>?
        get() = javaResource.storageEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * List of VPC security groups to associate with the Cluster
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.neptune.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.neptune.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
