@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterArgs.builder
import com.pulumi.aws.neptune.kotlin.inputs.ClusterServerlessV2ScalingConfigurationArgs
import com.pulumi.aws.neptune.kotlin.inputs.ClusterServerlessV2ScalingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Neptune Cluster Resource. A Cluster Resource defines attributes that are
 * applied to the entire cluster of Neptune Cluster Instances.
 * Changes to a Neptune Cluster can occur when you manually change a
 * parameter, such as `backup_retention_period`, and are reflected in the next maintenance
 * window. Because of this, this provider may report a difference in its planning
 * phase because a modification has not yet taken place. You can use the
 * `apply_immediately` flag to instruct the service to apply the change immediately
 * (see documentation below).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .applyImmediately(true)
 *             .backupRetentionPeriod(5)
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .iamDatabaseAuthenticationEnabled(true)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster` using the cluster identifier. For example:
 * ```sh
 *  $ pulumi import aws:neptune/cluster:Cluster example my-cluster
 * ```
 * @property allowMajorVersionUpgrade Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
 * @property applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
 * @property availabilityZones A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
 * @property backupRetentionPeriod The days to retain backups for. Default `1`
 * @property clusterIdentifier The cluster identifier. If omitted, this provider will assign a random, unique identifier.
 * @property clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
 * @property copyTagsToSnapshot If set to true, tags are copied to any snapshot of the DB cluster that is created.
 * @property deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
 * @property enableCloudwatchLogsExports A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
 * @property engine The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
 * @property engineVersion The database engine version.
 * @property finalSnapshotIdentifier The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
 * @property globalClusterIdentifier The global cluster identifier specified on `aws.neptune.GlobalCluster`.
 * @property iamDatabaseAuthenticationEnabled Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
 * @property iamRoles A List of ARNs for the IAM roles to associate to the Neptune Cluster.
 * @property kmsKeyArn The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
 * @property neptuneClusterParameterGroupName A cluster parameter group to associate with the cluster.
 * @property neptuneInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB cluster.
 * @property neptuneSubnetGroupName A Neptune subnet group to associate with this Neptune instance.
 * @property port The port on which the Neptune accepts connections. Default is `8182`.
 * @property preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
 * @property replicationSourceIdentifier ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
 * @property serverlessV2ScalingConfiguration If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
 * @property skipFinalSnapshot Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
 * @property snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
 * @property storageEncrypted Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
 * @property tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds List of VPC security groups to associate with the Cluster
 */
public data class ClusterArgs(
    public val allowMajorVersionUpgrade: Output<Boolean>? = null,
    public val applyImmediately: Output<Boolean>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val backupRetentionPeriod: Output<Int>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val clusterIdentifierPrefix: Output<String>? = null,
    public val copyTagsToSnapshot: Output<Boolean>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enableCloudwatchLogsExports: Output<List<String>>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val finalSnapshotIdentifier: Output<String>? = null,
    public val globalClusterIdentifier: Output<String>? = null,
    public val iamDatabaseAuthenticationEnabled: Output<Boolean>? = null,
    public val iamRoles: Output<List<String>>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val neptuneClusterParameterGroupName: Output<String>? = null,
    public val neptuneInstanceParameterGroupName: Output<String>? = null,
    public val neptuneSubnetGroupName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferredBackupWindow: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val replicationSourceIdentifier: Output<String>? = null,
    public val serverlessV2ScalingConfiguration: Output<ClusterServerlessV2ScalingConfigurationArgs>? =
        null,
    public val skipFinalSnapshot: Output<Boolean>? = null,
    public val snapshotIdentifier: Output<String>? = null,
    public val storageEncrypted: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterArgs =
        com.pulumi.aws.neptune.ClusterArgs.builder()
            .allowMajorVersionUpgrade(allowMajorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifierPrefix(clusterIdentifierPrefix?.applyValue({ args0 -> args0 }))
            .copyTagsToSnapshot(copyTagsToSnapshot?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enableCloudwatchLogsExports(
                enableCloudwatchLogsExports?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .finalSnapshotIdentifier(finalSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .globalClusterIdentifier(globalClusterIdentifier?.applyValue({ args0 -> args0 }))
            .iamDatabaseAuthenticationEnabled(iamDatabaseAuthenticationEnabled?.applyValue({ args0 -> args0 }))
            .iamRoles(iamRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .neptuneClusterParameterGroupName(neptuneClusterParameterGroupName?.applyValue({ args0 -> args0 }))
            .neptuneInstanceParameterGroupName(
                neptuneInstanceParameterGroupName?.applyValue({ args0 ->
                    args0
                }),
            )
            .neptuneSubnetGroupName(neptuneSubnetGroupName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferredBackupWindow(preferredBackupWindow?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .replicationSourceIdentifier(replicationSourceIdentifier?.applyValue({ args0 -> args0 }))
            .serverlessV2ScalingConfiguration(
                serverlessV2ScalingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .skipFinalSnapshot(skipFinalSnapshot?.applyValue({ args0 -> args0 }))
            .snapshotIdentifier(snapshotIdentifier?.applyValue({ args0 -> args0 }))
            .storageEncrypted(storageEncrypted?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var allowMajorVersionUpgrade: Output<Boolean>? = null

    private var applyImmediately: Output<Boolean>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var backupRetentionPeriod: Output<Int>? = null

    private var clusterIdentifier: Output<String>? = null

    private var clusterIdentifierPrefix: Output<String>? = null

    private var copyTagsToSnapshot: Output<Boolean>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enableCloudwatchLogsExports: Output<List<String>>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var finalSnapshotIdentifier: Output<String>? = null

    private var globalClusterIdentifier: Output<String>? = null

    private var iamDatabaseAuthenticationEnabled: Output<Boolean>? = null

    private var iamRoles: Output<List<String>>? = null

    private var kmsKeyArn: Output<String>? = null

    private var neptuneClusterParameterGroupName: Output<String>? = null

    private var neptuneInstanceParameterGroupName: Output<String>? = null

    private var neptuneSubnetGroupName: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferredBackupWindow: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var replicationSourceIdentifier: Output<String>? = null

    private var serverlessV2ScalingConfiguration: Output<ClusterServerlessV2ScalingConfigurationArgs>? =
        null

    private var skipFinalSnapshot: Output<Boolean>? = null

    private var snapshotIdentifier: Output<String>? = null

    private var storageEncrypted: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
     */
    @JvmName("jfxgtwcphcemtttx")
    public suspend fun allowMajorVersionUpgrade(`value`: Output<Boolean>) {
        this.allowMajorVersionUpgrade = value
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("mapwitenwdadmqfx")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("pkpwvnbbegehvwed")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("ddkgcpxutbjyfdej")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("xiswfikdrcivljsg")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("bkisnjcyhpgmggue")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("kynlpluukbjlmddg")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("ptawbpdvaiprajfk")
    public suspend fun clusterIdentifierPrefix(`value`: Output<String>) {
        this.clusterIdentifierPrefix = value
    }

    /**
     * @param value If set to true, tags are copied to any snapshot of the DB cluster that is created.
     */
    @JvmName("ssqqsgmaedkbjmva")
    public suspend fun copyTagsToSnapshot(`value`: Output<Boolean>) {
        this.copyTagsToSnapshot = value
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("inwuqmjlsmdhcmbn")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("hxhdniscbedrvgaj")
    public suspend fun enableCloudwatchLogsExports(`value`: Output<List<String>>) {
        this.enableCloudwatchLogsExports = value
    }

    @JvmName("wfqxbkmxvtprbtol")
    public suspend fun enableCloudwatchLogsExports(vararg values: Output<String>) {
        this.enableCloudwatchLogsExports = Output.all(values.asList())
    }

    /**
     * @param values A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("joxldsssmbynsanq")
    public suspend fun enableCloudwatchLogsExports(values: List<Output<String>>) {
        this.enableCloudwatchLogsExports = Output.all(values)
    }

    /**
     * @param value The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
     */
    @JvmName("lcaugwicljfmkkby")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The database engine version.
     */
    @JvmName("rsbsaydgdyjhcita")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("rsuvaefbjawieuxn")
    public suspend fun finalSnapshotIdentifier(`value`: Output<String>) {
        this.finalSnapshotIdentifier = value
    }

    /**
     * @param value The global cluster identifier specified on `aws.neptune.GlobalCluster`.
     */
    @JvmName("jowwkfwpwiqhkyiv")
    public suspend fun globalClusterIdentifier(`value`: Output<String>) {
        this.globalClusterIdentifier = value
    }

    /**
     * @param value Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    @JvmName("ifitncpopfdenudq")
    public suspend fun iamDatabaseAuthenticationEnabled(`value`: Output<Boolean>) {
        this.iamDatabaseAuthenticationEnabled = value
    }

    /**
     * @param value A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("vtqbqumyrhsyaush")
    public suspend fun iamRoles(`value`: Output<List<String>>) {
        this.iamRoles = value
    }

    @JvmName("lrytqxgqfexubfdj")
    public suspend fun iamRoles(vararg values: Output<String>) {
        this.iamRoles = Output.all(values.asList())
    }

    /**
     * @param values A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("nmfcyhcucpgmppfe")
    public suspend fun iamRoles(values: List<Output<String>>) {
        this.iamRoles = Output.all(values)
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("tdvpmxvlacboqthd")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("mcaaqyxlxjcecktk")
    public suspend fun neptuneClusterParameterGroupName(`value`: Output<String>) {
        this.neptuneClusterParameterGroupName = value
    }

    /**
     * @param value The name of the DB parameter group to apply to all instances of the DB cluster.
     */
    @JvmName("kysgempaemovrhce")
    public suspend fun neptuneInstanceParameterGroupName(`value`: Output<String>) {
        this.neptuneInstanceParameterGroupName = value
    }

    /**
     * @param value A Neptune subnet group to associate with this Neptune instance.
     */
    @JvmName("feqmykjyxgskahdi")
    public suspend fun neptuneSubnetGroupName(`value`: Output<String>) {
        this.neptuneSubnetGroupName = value
    }

    /**
     * @param value The port on which the Neptune accepts connections. Default is `8182`.
     */
    @JvmName("omwlwwkqfffoelgv")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("wafqvdyvyrqccrtv")
    public suspend fun preferredBackupWindow(`value`: Output<String>) {
        this.preferredBackupWindow = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("eklrgidhfmfnlysp")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
     */
    @JvmName("sptcgikhvfreauug")
    public suspend fun replicationSourceIdentifier(`value`: Output<String>) {
        this.replicationSourceIdentifier = value
    }

    /**
     * @param value If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("gquvfedcmrwjlcce")
    public suspend
    fun serverlessV2ScalingConfiguration(`value`: Output<ClusterServerlessV2ScalingConfigurationArgs>) {
        this.serverlessV2ScalingConfiguration = value
    }

    /**
     * @param value Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("dkgkqlgeomaveund")
    public suspend fun skipFinalSnapshot(`value`: Output<Boolean>) {
        this.skipFinalSnapshot = value
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("clcubpowwufnwbiq")
    public suspend fun snapshotIdentifier(`value`: Output<String>) {
        this.snapshotIdentifier = value
    }

    /**
     * @param value Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
     */
    @JvmName("otsbdkibnmmgwhsm")
    public suspend fun storageEncrypted(`value`: Output<Boolean>) {
        this.storageEncrypted = value
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ynewyfkurbuauwse")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of VPC security groups to associate with the Cluster
     */
    @JvmName("ewfngesgoaqswskk")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("pxixsmhrbwvbjmja")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC security groups to associate with the Cluster
     */
    @JvmName("gwatsjugalpnwjnf")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value Specifies whether upgrades between different major versions are allowed. You must set it to `true` when providing an `engine_version` parameter that uses a different major version than the DB cluster's current version. Default is `false`.
     */
    @JvmName("kxbaclbpkbgfsjdu")
    public suspend fun allowMajorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMajorVersionUpgrade = mapped
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("cskinywntkfahtas")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("iicbigbewyygcmyf")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values A list of EC2 Availability Zones that instances in the Neptune cluster can be created in.
     */
    @JvmName("vufrhahyebbalccv")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The days to retain backups for. Default `1`
     */
    @JvmName("iohfkqvfhejjwhmn")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("xqjxxcysquotytub")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     */
    @JvmName("quunlcfbpwdxbmwq")
    public suspend fun clusterIdentifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifierPrefix = mapped
    }

    /**
     * @param value If set to true, tags are copied to any snapshot of the DB cluster that is created.
     */
    @JvmName("dedamtddjurhpibc")
    public suspend fun copyTagsToSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToSnapshot = mapped
    }

    /**
     * @param value A value that indicates whether the DB cluster has deletion protection enabled.The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @JvmName("svuefethlsyhsohv")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("lqihsyrvukieeodf")
    public suspend fun enableCloudwatchLogsExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCloudwatchLogsExports = mapped
    }

    /**
     * @param values A list of the log types this DB cluster is configured to export to Cloudwatch Logs. Currently only supports `audit` and `slowquery`.
     */
    @JvmName("cuemcyyqembealjg")
    public suspend fun enableCloudwatchLogsExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableCloudwatchLogsExports = mapped
    }

    /**
     * @param value The name of the database engine to be used for this Neptune cluster. Defaults to `neptune`.
     */
    @JvmName("wmbgwjckthrijtqr")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The database engine version.
     */
    @JvmName("noeggeqeqykqnihe")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The name of your final Neptune snapshot when this Neptune cluster is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("bwvfwtfnytqksjdh")
    public suspend fun finalSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotIdentifier = mapped
    }

    /**
     * @param value The global cluster identifier specified on `aws.neptune.GlobalCluster`.
     */
    @JvmName("mgjskignktblkovb")
    public suspend fun globalClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalClusterIdentifier = mapped
    }

    /**
     * @param value Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    @JvmName("tjxauvvwoisieulk")
    public suspend fun iamDatabaseAuthenticationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamDatabaseAuthenticationEnabled = mapped
    }

    /**
     * @param value A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("vqissjoglptermsh")
    public suspend fun iamRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param values A List of ARNs for the IAM roles to associate to the Neptune Cluster.
     */
    @JvmName("etupplkyjrkbfraf")
    public suspend fun iamRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_arn`, `storage_encrypted` needs to be set to true.
     */
    @JvmName("gffssgidvwfxwgwk")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value A cluster parameter group to associate with the cluster.
     */
    @JvmName("mflnawhpvubmhyox")
    public suspend fun neptuneClusterParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneClusterParameterGroupName = mapped
    }

    /**
     * @param value The name of the DB parameter group to apply to all instances of the DB cluster.
     */
    @JvmName("bpbpkbkkicvjiyga")
    public suspend fun neptuneInstanceParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneInstanceParameterGroupName = mapped
    }

    /**
     * @param value A Neptune subnet group to associate with this Neptune instance.
     */
    @JvmName("glvqowtohrjwxjyo")
    public suspend fun neptuneSubnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneSubnetGroupName = mapped
    }

    /**
     * @param value The port on which the Neptune accepts connections. Default is `8182`.
     */
    @JvmName("cpbaqfjcdftlqqsw")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     */
    @JvmName("wmkrhscueddsornv")
    public suspend fun preferredBackupWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupWindow = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     */
    @JvmName("rsaymuhtiecvcnrk")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value ARN of a source Neptune cluster or Neptune instance if this Neptune cluster is to be created as a Read Replica.
     */
    @JvmName("afodclwsuhuiydgk")
    public suspend fun replicationSourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSourceIdentifier = mapped
    }

    /**
     * @param value If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("nwcjmbwwtclkjumn")
    public suspend
    fun serverlessV2ScalingConfiguration(`value`: ClusterServerlessV2ScalingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessV2ScalingConfiguration = mapped
    }

    /**
     * @param argument If set, create the Neptune cluster as a serverless one. See Serverless for example block attributes.
     */
    @JvmName("baudklkvdfngnkla")
    public suspend
    fun serverlessV2ScalingConfiguration(argument: suspend ClusterServerlessV2ScalingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterServerlessV2ScalingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverlessV2ScalingConfiguration = mapped
    }

    /**
     * @param value Determines whether a final Neptune snapshot is created before the Neptune cluster is deleted. If true is specified, no Neptune snapshot is created. If false is specified, a Neptune snapshot is created before the Neptune cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     */
    @JvmName("glriirnllwigvofn")
    public suspend fun skipFinalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalSnapshot = mapped
    }

    /**
     * @param value Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a Neptune cluster snapshot, or the ARN when specifying a Neptune snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     */
    @JvmName("xhshtjeraprifbrs")
    public suspend fun snapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotIdentifier = mapped
    }

    /**
     * @param value Specifies whether the Neptune cluster is encrypted. The default is `false` if not specified.
     */
    @JvmName("rxarnpeppwixvhny")
    public suspend fun storageEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEncrypted = mapped
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("osupdykrsgnvcdlv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hjplliytwurnxgce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of VPC security groups to associate with the Cluster
     */
    @JvmName("ymebmvcgxofjdyew")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of VPC security groups to associate with the Cluster
     */
    @JvmName("bubnlprwvksxiiwc")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        allowMajorVersionUpgrade = allowMajorVersionUpgrade,
        applyImmediately = applyImmediately,
        availabilityZones = availabilityZones,
        backupRetentionPeriod = backupRetentionPeriod,
        clusterIdentifier = clusterIdentifier,
        clusterIdentifierPrefix = clusterIdentifierPrefix,
        copyTagsToSnapshot = copyTagsToSnapshot,
        deletionProtection = deletionProtection,
        enableCloudwatchLogsExports = enableCloudwatchLogsExports,
        engine = engine,
        engineVersion = engineVersion,
        finalSnapshotIdentifier = finalSnapshotIdentifier,
        globalClusterIdentifier = globalClusterIdentifier,
        iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled,
        iamRoles = iamRoles,
        kmsKeyArn = kmsKeyArn,
        neptuneClusterParameterGroupName = neptuneClusterParameterGroupName,
        neptuneInstanceParameterGroupName = neptuneInstanceParameterGroupName,
        neptuneSubnetGroupName = neptuneSubnetGroupName,
        port = port,
        preferredBackupWindow = preferredBackupWindow,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        replicationSourceIdentifier = replicationSourceIdentifier,
        serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration,
        skipFinalSnapshot = skipFinalSnapshot,
        snapshotIdentifier = snapshotIdentifier,
        storageEncrypted = storageEncrypted,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
