@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Neptune Cluster Endpoint Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterEndpoint;
 * import com.pulumi.aws.neptune.ClusterEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterEndpoint("example", ClusterEndpointArgs.builder()
 *             .clusterIdentifier(aws_neptune_cluster.test().cluster_identifier())
 *             .clusterEndpointIdentifier("example")
 *             .endpointType("READER")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_endpoint` using the `cluster-identifier:endpoint-identfier`. For example:
 * ```sh
 *  $ pulumi import aws:neptune/clusterEndpoint:ClusterEndpoint example my-cluster:my-endpoint
 * ```
 * @property clusterEndpointIdentifier The identifier of the endpoint.
 * @property clusterIdentifier The DB cluster identifier of the DB cluster associated with the endpoint.
 * @property endpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
 * @property excludedMembers List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
 * @property staticMembers List of DB instance identifiers that are part of the custom endpoint group.
 * @property tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterEndpointArgs(
    public val clusterEndpointIdentifier: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val excludedMembers: Output<List<String>>? = null,
    public val staticMembers: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterEndpointArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterEndpointArgs =
        com.pulumi.aws.neptune.ClusterEndpointArgs.builder()
            .clusterEndpointIdentifier(clusterEndpointIdentifier?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .excludedMembers(excludedMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .staticMembers(staticMembers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterEndpointArgs].
 */
@PulumiTagMarker
public class ClusterEndpointArgsBuilder internal constructor() {
    private var clusterEndpointIdentifier: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var excludedMembers: Output<List<String>>? = null

    private var staticMembers: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identifier of the endpoint.
     */
    @JvmName("yomdigxfuvkfjhdk")
    public suspend fun clusterEndpointIdentifier(`value`: Output<String>) {
        this.clusterEndpointIdentifier = value
    }

    /**
     * @param value The DB cluster identifier of the DB cluster associated with the endpoint.
     */
    @JvmName("upbkfurwqhbnlkiv")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     */
    @JvmName("nhbfxqmuatudtrgp")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("kyufyssredrwodbr")
    public suspend fun excludedMembers(`value`: Output<List<String>>) {
        this.excludedMembers = value
    }

    @JvmName("buwnvqputbghftsw")
    public suspend fun excludedMembers(vararg values: Output<String>) {
        this.excludedMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("tqdwjifbsbsgdfhy")
    public suspend fun excludedMembers(values: List<Output<String>>) {
        this.excludedMembers = Output.all(values)
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("smwsgwujbvbvkwuq")
    public suspend fun staticMembers(`value`: Output<List<String>>) {
        this.staticMembers = value
    }

    @JvmName("yghksmujswbkpbrf")
    public suspend fun staticMembers(vararg values: Output<String>) {
        this.staticMembers = Output.all(values.asList())
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("bsevlvjmniaqsqgm")
    public suspend fun staticMembers(values: List<Output<String>>) {
        this.staticMembers = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpjntfirvfntsynd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identifier of the endpoint.
     */
    @JvmName("vbkholutsdodavtb")
    public suspend fun clusterEndpointIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpointIdentifier = mapped
    }

    /**
     * @param value The DB cluster identifier of the DB cluster associated with the endpoint.
     */
    @JvmName("jjiwififsvcubxqy")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     */
    @JvmName("nvuyvykolnhvkebk")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("dpvacsqsnwuqwsuq")
    public suspend fun excludedMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     */
    @JvmName("pdcjgysjhoegmpmf")
    public suspend fun excludedMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedMembers = mapped
    }

    /**
     * @param value List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("gatersqknevsplit")
    public suspend fun staticMembers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param values List of DB instance identifiers that are part of the custom endpoint group.
     */
    @JvmName("uoaskgvrkovmkeqj")
    public suspend fun staticMembers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticMembers = mapped
    }

    /**
     * @param value A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nbyqbtqthdybgihs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tgmaufdxgneoecia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterEndpointArgs = ClusterEndpointArgs(
        clusterEndpointIdentifier = clusterEndpointIdentifier,
        clusterIdentifier = clusterIdentifier,
        endpointType = endpointType,
        excludedMembers = excludedMembers,
        staticMembers = staticMembers,
        tags = tags,
    )
}
