@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClusterInstance].
 */
@PulumiTagMarker
public class ClusterInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterInstanceArgs = ClusterInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterInstanceArgsBuilder.() -> Unit) {
        val builder = ClusterInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClusterInstance {
        val builtJavaResource = com.pulumi.aws.neptune.ClusterInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterInstance(builtJavaResource)
    }
}

/**
 * A Cluster Instance Resource defines attributes that are specific to a single instance in a Neptune Cluster.
 * You can simply add neptune instances and Neptune manages the replication. You can use the count
 * meta-parameter to make multiple instances and join them all to the same Neptune Cluster, or you may specify different Cluster Instance resources with various `instance_class` sizes.
 * ## Example Usage
 * The following example will create a neptune cluster with two neptune instances(one writer and one reader).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import com.pulumi.aws.neptune.ClusterInstance;
 * import com.pulumi.aws.neptune.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .iamDatabaseAuthenticationEnabled(true)
 *             .applyImmediately(true)
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new ClusterInstance("example-" + i, ClusterInstanceArgs.builder()
 *                 .clusterIdentifier(default_.id())
 *                 .engine("neptune")
 *                 .instanceClass("db.r4.large")
 *                 .applyImmediately(true)
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_instance` using the instance identifier. For example:
 * ```sh
 *  $ pulumi import aws:neptune/clusterInstance:ClusterInstance example my-instance
 * ```
 *
 */
public class ClusterInstance internal constructor(
    override val javaResource: com.pulumi.aws.neptune.ClusterInstance,
) : KotlinCustomResource(javaResource, ClusterInstanceMapper) {
    /**
     * The hostname of the instance. See also `endpoint` and `port`.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    public val applyImmediately: Output<Boolean>
        get() = javaResource.applyImmediately().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of neptune instance
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The EC2 Availability Zone that the neptune instance is created in.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The region-unique, immutable identifier for the neptune instance.
     */
    public val dbiResourceId: Output<String>
        get() = javaResource.dbiResourceId().applyValue({ args0 -> args0 })

    /**
     * The connection endpoint in `address:port` format.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     */
    public val engine: Output<String>?
        get() = javaResource.engine().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The neptune engine version. Currently configuring this argumnet has no effect.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    public val identifierPrefix: Output<String>
        get() = javaResource.identifierPrefix().applyValue({ args0 -> args0 })

    /**
     * The instance class to use.
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key if one is set to the neptune cluster.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * The name of the neptune parameter group to associate with this instance.
     */
    public val neptuneParameterGroupName: Output<String>?
        get() = javaResource.neptuneParameterGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     */
    public val neptuneSubnetGroupName: Output<String>
        get() = javaResource.neptuneSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * The port on which the DB accepts connections. Defaults to `8182`.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
     */
    public val preferredBackupWindow: Output<String>
        get() = javaResource.preferredBackupWindow().applyValue({ args0 -> args0 })

    /**
     * The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    public val promotionTier: Output<Int>?
        get() = javaResource.promotionTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Bool to control if instance is publicly accessible. Default is `false`.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the neptune cluster is encrypted.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     */
    public val writer: Output<Boolean>
        get() = javaResource.writer().applyValue({ args0 -> args0 })
}

public object ClusterInstanceMapper : ResourceMapper<ClusterInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.neptune.ClusterInstance::class == javaResource::class

    override fun map(javaResource: Resource): ClusterInstance = ClusterInstance(
        javaResource as
            com.pulumi.aws.neptune.ClusterInstance,
    )
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterInstance].
 */
public suspend fun clusterInstance(
    name: String,
    block: suspend ClusterInstanceResourceBuilder.() -> Unit,
): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterInstance(name: String): ClusterInstance {
    val builder = ClusterInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
