@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Cluster Instance Resource defines attributes that are specific to a single instance in a Neptune Cluster.
 * You can simply add neptune instances and Neptune manages the replication. You can use the count
 * meta-parameter to make multiple instances and join them all to the same Neptune Cluster, or you may specify different Cluster Instance resources with various `instance_class` sizes.
 * ## Example Usage
 * The following example will create a neptune cluster with two neptune instances(one writer and one reader).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.Cluster;
 * import com.pulumi.aws.neptune.ClusterArgs;
 * import com.pulumi.aws.neptune.ClusterInstance;
 * import com.pulumi.aws.neptune.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("neptune-cluster-demo")
 *             .engine("neptune")
 *             .backupRetentionPeriod(5)
 *             .preferredBackupWindow("07:00-09:00")
 *             .skipFinalSnapshot(true)
 *             .iamDatabaseAuthenticationEnabled(true)
 *             .applyImmediately(true)
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new ClusterInstance("example-" + i, ClusterInstanceArgs.builder()
 *                 .clusterIdentifier(default_.id())
 *                 .engine("neptune")
 *                 .instanceClass("db.r4.large")
 *                 .applyImmediately(true)
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_neptune_cluster_instance` using the instance identifier. For example:
 * ```sh
 *  $ pulumi import aws:neptune/clusterInstance:ClusterInstance example my-instance
 * ```
 * @property applyImmediately Specifies whether any instance modifications
 * are applied immediately, or during the next maintenance window. Default is`false`.
 * @property autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
 * @property availabilityZone The EC2 Availability Zone that the neptune instance is created in.
 * @property clusterIdentifier The identifier of the `aws.neptune.Cluster` in which to launch this instance.
 * @property engine The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
 * @property engineVersion The neptune engine version. Currently configuring this argumnet has no effect.
 * @property identifier The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
 * @property identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
 * @property instanceClass The instance class to use.
 * @property neptuneParameterGroupName The name of the neptune parameter group to associate with this instance.
 * @property neptuneSubnetGroupName A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
 * @property port The port on which the DB accepts connections. Defaults to `8182`.
 * @property preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
 * @property preferredMaintenanceWindow The window to perform maintenance in.
 * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
 * @property promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
 * @property publiclyAccessible Bool to control if instance is publicly accessible. Default is `false`.
 * @property tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterInstanceArgs(
    public val applyImmediately: Output<Boolean>? = null,
    public val autoMinorVersionUpgrade: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val identifier: Output<String>? = null,
    public val identifierPrefix: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val neptuneParameterGroupName: Output<String>? = null,
    public val neptuneSubnetGroupName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferredBackupWindow: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val promotionTier: Output<Int>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterInstanceArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterInstanceArgs =
        com.pulumi.aws.neptune.ClusterInstanceArgs.builder()
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .autoMinorVersionUpgrade(autoMinorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .identifierPrefix(identifierPrefix?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .neptuneParameterGroupName(neptuneParameterGroupName?.applyValue({ args0 -> args0 }))
            .neptuneSubnetGroupName(neptuneSubnetGroupName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferredBackupWindow(preferredBackupWindow?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .promotionTier(promotionTier?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterInstanceArgs].
 */
@PulumiTagMarker
public class ClusterInstanceArgsBuilder internal constructor() {
    private var applyImmediately: Output<Boolean>? = null

    private var autoMinorVersionUpgrade: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var identifier: Output<String>? = null

    private var identifierPrefix: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var neptuneParameterGroupName: Output<String>? = null

    private var neptuneSubnetGroupName: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferredBackupWindow: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var promotionTier: Output<Int>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    @JvmName("tkvuywlbriqdallf")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     */
    @JvmName("ahgpfipbgpsrhxqv")
    public suspend fun autoMinorVersionUpgrade(`value`: Output<Boolean>) {
        this.autoMinorVersionUpgrade = value
    }

    /**
     * @param value The EC2 Availability Zone that the neptune instance is created in.
     */
    @JvmName("nlmdctscnrrsyuxl")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     */
    @JvmName("liulkqfbpqcajnvn")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     */
    @JvmName("dqhyfwhavpvsqcek")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The neptune engine version. Currently configuring this argumnet has no effect.
     */
    @JvmName("adkqorqoivrqrumm")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("cqrmpiypxhwtmags")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("tyslsewbrvnmqlaj")
    public suspend fun identifierPrefix(`value`: Output<String>) {
        this.identifierPrefix = value
    }

    /**
     * @param value The instance class to use.
     */
    @JvmName("vdnbjvjgvxmbytij")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The name of the neptune parameter group to associate with this instance.
     */
    @JvmName("cogqmmhaycjdcvae")
    public suspend fun neptuneParameterGroupName(`value`: Output<String>) {
        this.neptuneParameterGroupName = value
    }

    /**
     * @param value A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     */
    @JvmName("njmpbcjlaacibwuq")
    public suspend fun neptuneSubnetGroupName(`value`: Output<String>) {
        this.neptuneSubnetGroupName = value
    }

    /**
     * @param value The port on which the DB accepts connections. Defaults to `8182`.
     */
    @JvmName("wcsfcbwfpjolpnes")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
     */
    @JvmName("ydnqevjihkirlxha")
    public suspend fun preferredBackupWindow(`value`: Output<String>) {
        this.preferredBackupWindow = value
    }

    /**
     * @param value The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    @JvmName("njlnwuytnnwxdbsy")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    @JvmName("sqdjrnjbsrtwafcm")
    public suspend fun promotionTier(`value`: Output<Int>) {
        this.promotionTier = value
    }

    /**
     * @param value Bool to control if instance is publicly accessible. Default is `false`.
     */
    @JvmName("tswmnqbywclcxhce")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iemnurrejduiwhda")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     */
    @JvmName("rffcxakudjcwivfd")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     */
    @JvmName("lpeouspchlinycgm")
    public suspend fun autoMinorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMinorVersionUpgrade = mapped
    }

    /**
     * @param value The EC2 Availability Zone that the neptune instance is created in.
     */
    @JvmName("duhhyftmpcmikvmq")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     */
    @JvmName("fectnlrpbfjlaitd")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     */
    @JvmName("flgquavgrgbecxbi")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The neptune engine version. Currently configuring this argumnet has no effect.
     */
    @JvmName("vmlwcukboysmgsnx")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("anfnovqwcwigvqxa")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("ynvnrlcqybhlgvmf")
    public suspend fun identifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifierPrefix = mapped
    }

    /**
     * @param value The instance class to use.
     */
    @JvmName("ltqlnqowwbijnqlg")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The name of the neptune parameter group to associate with this instance.
     */
    @JvmName("emxorkfcejfihqsv")
    public suspend fun neptuneParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneParameterGroupName = mapped
    }

    /**
     * @param value A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     */
    @JvmName("bpspmtwhqnxjhpdf")
    public suspend fun neptuneSubnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptuneSubnetGroupName = mapped
    }

    /**
     * @param value The port on which the DB accepts connections. Defaults to `8182`.
     */
    @JvmName("ohhdcoaipoxyiudt")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00"
     */
    @JvmName("mjhvfhlxqbuabwrc")
    public suspend fun preferredBackupWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupWindow = mapped
    }

    /**
     * @param value The window to perform maintenance in.
     * Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
     */
    @JvmName("hqgnaspgejpcwssa")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     */
    @JvmName("jwawidbhbgqjvgjy")
    public suspend fun promotionTier(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionTier = mapped
    }

    /**
     * @param value Bool to control if instance is publicly accessible. Default is `false`.
     */
    @JvmName("rwfcspgspjqpproj")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gntypgjeauhtgseq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jqitqetoyctjefnq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterInstanceArgs = ClusterInstanceArgs(
        applyImmediately = applyImmediately,
        autoMinorVersionUpgrade = autoMinorVersionUpgrade,
        availabilityZone = availabilityZone,
        clusterIdentifier = clusterIdentifier,
        engine = engine,
        engineVersion = engineVersion,
        identifier = identifier,
        identifierPrefix = identifierPrefix,
        instanceClass = instanceClass,
        neptuneParameterGroupName = neptuneParameterGroupName,
        neptuneSubnetGroupName = neptuneSubnetGroupName,
        port = port,
        preferredBackupWindow = preferredBackupWindow,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        promotionTier = promotionTier,
        publiclyAccessible = publiclyAccessible,
        tags = tags,
    )
}
