@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ClusterParameterGroupArgs.builder
import com.pulumi.aws.neptune.kotlin.inputs.ClusterParameterGroupParameterArgs
import com.pulumi.aws.neptune.kotlin.inputs.ClusterParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Neptune Cluster Parameter Group
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ClusterParameterGroup;
 * import com.pulumi.aws.neptune.ClusterParameterGroupArgs;
 * import com.pulumi.aws.neptune.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterParameterGroup("example", ClusterParameterGroupArgs.builder()
 *             .description("neptune cluster parameter group")
 *             .family("neptune1")
 *             .parameters(ClusterParameterGroupParameterArgs.builder()
 *                 .name("neptune_enable_audit_log")
 *                 .value(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Neptune Cluster Parameter Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:neptune/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 * @property description The description of the neptune cluster parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the neptune cluster parameter group.
 * @property name The name of the neptune parameter.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters A list of neptune parameters to apply.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ClusterParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ClusterParameterGroupArgs =
        com.pulumi.aws.neptune.ClusterParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterParameterGroupArgs].
 */
@PulumiTagMarker
public class ClusterParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the neptune cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("jxyolgnbgskljwdf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the neptune cluster parameter group.
     */
    @JvmName("xjteiweeicdimpio")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the neptune parameter.
     */
    @JvmName("jilgbeguqemaltax")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("elqvgbcapyjkubhm")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of neptune parameters to apply.
     */
    @JvmName("fsxxtcbrmcvhythh")
    public suspend fun parameters(`value`: Output<List<ClusterParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("nrgygytvbuclwdxp")
    public suspend fun parameters(vararg values: Output<ClusterParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of neptune parameters to apply.
     */
    @JvmName("tiwsqmikuchbjgol")
    public suspend fun parameters(values: List<Output<ClusterParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ofcifkptsassnfpe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the neptune cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("lmxxotehhmuitdfj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the neptune cluster parameter group.
     */
    @JvmName("sqfbpyxlntgitjkf")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the neptune parameter.
     */
    @JvmName("hywnasstvafndgjj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("lwakfympptmibtbk")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of neptune parameters to apply.
     */
    @JvmName("rjtccmttuvydogxm")
    public suspend fun parameters(`value`: List<ClusterParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of neptune parameters to apply.
     */
    @JvmName("lwlcireoopffnymt")
    public suspend
    fun parameters(argument: List<suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of neptune parameters to apply.
     */
    @JvmName("xecviusbbcittwdf")
    public suspend fun parameters(
        vararg
        argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of neptune parameters to apply.
     */
    @JvmName("hbsdxblwsvayxpbm")
    public suspend
    fun parameters(argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of neptune parameters to apply.
     */
    @JvmName("gkknhadccajtthpe")
    public suspend fun parameters(vararg values: ClusterParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vfvuejpewloqqnyh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vcuxnumqaslekflp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterParameterGroupArgs = ClusterParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
