@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.NeptuneFunctions.getEngineVersionPlain
import com.pulumi.aws.neptune.NeptuneFunctions.getOrderableDbInstancePlain
import com.pulumi.aws.neptune.kotlin.inputs.GetEngineVersionPlainArgs
import com.pulumi.aws.neptune.kotlin.inputs.GetEngineVersionPlainArgsBuilder
import com.pulumi.aws.neptune.kotlin.inputs.GetOrderableDbInstancePlainArgs
import com.pulumi.aws.neptune.kotlin.inputs.GetOrderableDbInstancePlainArgsBuilder
import com.pulumi.aws.neptune.kotlin.outputs.GetEngineVersionResult
import com.pulumi.aws.neptune.kotlin.outputs.GetOrderableDbInstanceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.neptune.kotlin.outputs.GetEngineVersionResult.Companion.toKotlin as getEngineVersionResultToKotlin
import com.pulumi.aws.neptune.kotlin.outputs.GetOrderableDbInstanceResult.Companion.toKotlin as getOrderableDbInstanceResultToKotlin

public object NeptuneFunctions {
    /**
     * Information about a Neptune engine version.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.neptune.NeptuneFunctions;
     * import com.pulumi.aws.neptune.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = NeptuneFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .preferredVersions(
     *                 "1.0.3.0",
     *                 "1.0.2.2",
     *                 "1.0.2.1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEngineVersion.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: GetEngineVersionPlainArgs): GetEngineVersionResult =
        getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())

    /**
     * @see [getEngineVersion].
     * @param engine DB engine. (Default: `neptune`)
     * @param parameterGroupFamily Name of a specific DB parameter group family. An example parameter group family is `neptune1`.
     * @param preferredVersions Ordered list of preferred engine versions. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @param version Version of the DB engine. For example, `1.0.1.0`, `1.0.2.2`, and `1.0.3.0`. If both the `version` and `preferred_versions` arguments are not configured, the data source will return the default version for the engine.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(
        engine: String? = null,
        parameterGroupFamily: String? = null,
        preferredVersions: List<String>? = null,
        version: String? = null,
    ): GetEngineVersionResult {
        val argument = GetEngineVersionPlainArgs(
            engine = engine,
            parameterGroupFamily = parameterGroupFamily,
            preferredVersions = preferredVersions,
            version = version,
        )
        return getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEngineVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;neptune&#46;kotlin&#46;inputs&#46;GetEngineVersionPlainArgs].
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend
    fun getEngineVersion(argument: suspend GetEngineVersionPlainArgsBuilder.() -> Unit):
        GetEngineVersionResult {
        val builder = GetEngineVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEngineVersionResultToKotlin(getEngineVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about Neptune orderable DB instances.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.neptune.NeptuneFunctions;
     * import com.pulumi.aws.neptune.inputs.GetOrderableDbInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = NeptuneFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
     *             .engineVersion("1.0.3.0")
     *             .preferredInstanceClasses(
     *                 "db.r5.large",
     *                 "db.r4.large",
     *                 "db.t3.medium")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrderableDbInstance.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: GetOrderableDbInstancePlainArgs):
        GetOrderableDbInstanceResult =
        getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())

    /**
     * @see [getOrderableDbInstance].
     * @param engine DB engine. (Default: `neptune`)
     * @param engineVersion Version of the DB engine. For example, `1.0.1.0`, `1.0.1.2`, `1.0.2.2`, and `1.0.3.0`.
     * @param instanceClass DB instance class. Examples of classes are `db.r5.large`, `db.r5.xlarge`, `db.r4.large`, `db.r5.4xlarge`, `db.r5.12xlarge`, `db.r4.xlarge`, and `db.t3.medium`.
     * @param licenseModel License model. (Default: `amazon-license`)
     * @param preferredInstanceClasses Ordered list of preferred Neptune DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @param vpc Enable to show only VPC offerings.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(
        engine: String? = null,
        engineVersion: String? = null,
        instanceClass: String? = null,
        licenseModel: String? = null,
        preferredInstanceClasses: List<String>? = null,
        vpc: Boolean? = null,
    ): GetOrderableDbInstanceResult {
        val argument = GetOrderableDbInstancePlainArgs(
            engine = engine,
            engineVersion = engineVersion,
            instanceClass = instanceClass,
            licenseModel = licenseModel,
            preferredInstanceClasses = preferredInstanceClasses,
            vpc = vpc,
        )
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableDbInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;neptune&#46;kotlin&#46;inputs&#46;GetOrderableDbInstancePlainArgs].
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend
    fun getOrderableDbInstance(argument: suspend GetOrderableDbInstancePlainArgsBuilder.() -> Unit):
        GetOrderableDbInstanceResult {
        val builder = GetOrderableDbInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(builtArgument.toJava()).await())
    }
}
