@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.aws.neptune.ParameterGroupArgs.builder
import com.pulumi.aws.neptune.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.neptune.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Neptune Parameter Group
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.ParameterGroup;
 * import com.pulumi.aws.neptune.ParameterGroupArgs;
 * import com.pulumi.aws.neptune.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .family("neptune1")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .name("neptune_query_timeout")
 *                 .value("25")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Neptune Parameter Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:neptune/parameterGroup:ParameterGroup some_pg some-pg
 * ```
 * @property description The description of the Neptune parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the Neptune parameter group.
 * @property name The name of the Neptune parameter.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters A list of Neptune parameters to apply.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.neptune.ParameterGroupArgs =
        com.pulumi.aws.neptune.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Neptune parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("gcuefmgrmieimnni")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the Neptune parameter group.
     */
    @JvmName("yutejvqeoeyutyvq")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the Neptune parameter.
     */
    @JvmName("hibjrmpetmtgwldb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("bdaovqkqfeufcfrg")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of Neptune parameters to apply.
     */
    @JvmName("qakolcpixueleqds")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("yvarwgqruehbvimy")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of Neptune parameters to apply.
     */
    @JvmName("binuwgcnlepcbpxf")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sbvvlvbbkoosqgpr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Neptune parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("cfrckrhdcmrfkllr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the Neptune parameter group.
     */
    @JvmName("alfjwgsmhsjjudfw")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the Neptune parameter.
     */
    @JvmName("vpbqijbhxppxlbpg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("vtlmaigcqqucwylv")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of Neptune parameters to apply.
     */
    @JvmName("kqhgupumlahffuex")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of Neptune parameters to apply.
     */
    @JvmName("deypiqilhxrhnsep")
    public suspend
    fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of Neptune parameters to apply.
     */
    @JvmName("jqhmtjtaseqwtlwp")
    public suspend fun parameters(
        vararg
        argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of Neptune parameters to apply.
     */
    @JvmName("hdijmcgmcxadkinr")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of Neptune parameters to apply.
     */
    @JvmName("bvhlplktqxglhxvj")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dowgdrxeethbmewn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cbydgybucymnmpqi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
