@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SubnetGroup].
 */
@PulumiTagMarker
public class SubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetGroupArgs = SubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetGroupArgsBuilder.() -> Unit) {
        val builder = SubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SubnetGroup {
        val builtJavaResource = com.pulumi.aws.neptune.SubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SubnetGroup(builtJavaResource)
    }
}

/**
 * Provides an Neptune subnet group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.neptune.SubnetGroup;
 * import com.pulumi.aws.neptune.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SubnetGroup("default", SubnetGroupArgs.builder()
 *             .subnetIds(
 *                 aws_subnet.frontend().id(),
 *                 aws_subnet.backend().id())
 *             .tags(Map.of("Name", "My neptune subnet group"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Neptune Subnet groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:neptune/subnetGroup:SubnetGroup default production-subnet-group
 * ```
 *
 */
public class SubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.neptune.SubnetGroup,
) : KotlinCustomResource(javaResource, SubnetGroupMapper) {
    /**
     * The ARN of the neptune subnet group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the neptune subnet group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the neptune subnet group. If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of VPC subnet IDs.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SubnetGroupMapper : ResourceMapper<SubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.neptune.SubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): SubnetGroup = SubnetGroup(
        javaResource as
            com.pulumi.aws.neptune.SubnetGroup,
    )
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubnetGroup].
 */
public suspend fun subnetGroup(name: String, block: suspend SubnetGroupResourceBuilder.() -> Unit):
    SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnetGroup(name: String): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
