@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.inputs

import com.pulumi.aws.neptune.inputs.GetOrderableDbInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrderableDbInstance.
 * @property engine DB engine. (Default: `neptune`)
 * @property engineVersion Version of the DB engine. For example, `1.0.1.0`, `1.0.1.2`, `1.0.2.2`, and `1.0.3.0`.
 * @property instanceClass DB instance class. Examples of classes are `db.r5.large`, `db.r5.xlarge`, `db.r4.large`, `db.r5.4xlarge`, `db.r5.12xlarge`, `db.r4.xlarge`, and `db.t3.medium`.
 * @property licenseModel License model. (Default: `amazon-license`)
 * @property preferredInstanceClasses Ordered list of preferred Neptune DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
 * @property vpc Enable to show only VPC offerings.
 */
public data class GetOrderableDbInstancePlainArgs(
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceClass: String? = null,
    public val licenseModel: String? = null,
    public val preferredInstanceClasses: List<String>? = null,
    public val vpc: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.neptune.inputs.GetOrderableDbInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.neptune.inputs.GetOrderableDbInstancePlainArgs =
        com.pulumi.aws.neptune.inputs.GetOrderableDbInstancePlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .licenseModel(licenseModel?.let({ args0 -> args0 }))
            .preferredInstanceClasses(preferredInstanceClasses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpc(vpc?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderableDbInstancePlainArgs].
 */
@PulumiTagMarker
public class GetOrderableDbInstancePlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceClass: String? = null

    private var licenseModel: String? = null

    private var preferredInstanceClasses: List<String>? = null

    private var vpc: Boolean? = null

    /**
     * @param value DB engine. (Default: `neptune`)
     */
    @JvmName("fanquymwkfpfjmmu")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Version of the DB engine. For example, `1.0.1.0`, `1.0.1.2`, `1.0.2.2`, and `1.0.3.0`.
     */
    @JvmName("bxpdexvvnlkffhlt")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value DB instance class. Examples of classes are `db.r5.large`, `db.r5.xlarge`, `db.r4.large`, `db.r5.4xlarge`, `db.r5.12xlarge`, `db.r4.xlarge`, and `db.t3.medium`.
     */
    @JvmName("kkhgvpmgoppxrsky")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value License model. (Default: `amazon-license`)
     */
    @JvmName("pvdtqylxrahrhhxd")
    public suspend fun licenseModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.licenseModel = mapped
    }

    /**
     * @param value Ordered list of preferred Neptune DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("mtvwkmgfwgssdxwh")
    public suspend fun preferredInstanceClasses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param values Ordered list of preferred Neptune DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("shaiqjjjepjqdwlf")
    public suspend fun preferredInstanceClasses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param value Enable to show only VPC offerings.
     */
    @JvmName("bxfbdpwslvoiphlb")
    public suspend fun vpc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpc = mapped
    }

    internal fun build(): GetOrderableDbInstancePlainArgs = GetOrderableDbInstancePlainArgs(
        engine = engine,
        engineVersion = engineVersion,
        instanceClass = instanceClass,
        licenseModel = licenseModel,
        preferredInstanceClasses = preferredInstanceClasses,
        vpc = vpc,
    )
}
