@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.neptune.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrderableDbInstance.
 * @property availabilityZones Availability zones where the instance is available.
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceClass
 * @property licenseModel
 * @property maxIopsPerDbInstance Maximum total provisioned IOPS for a DB instance.
 * @property maxIopsPerGib Maximum provisioned IOPS per GiB for a DB instance.
 * @property maxStorageSize Maximum storage size for a DB instance.
 * @property minIopsPerDbInstance Minimum total provisioned IOPS for a DB instance.
 * @property minIopsPerGib Minimum provisioned IOPS per GiB for a DB instance.
 * @property minStorageSize Minimum storage size for a DB instance.
 * @property multiAzCapable Whether a DB instance is Multi-AZ capable.
 * @property preferredInstanceClasses
 * @property readReplicaCapable Whether a DB instance can have a read replica.
 * @property storageType Storage type for a DB instance.
 * @property supportsEnhancedMonitoring Whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
 * @property supportsIamDatabaseAuthentication Whether a DB instance supports IAM database authentication.
 * @property supportsIops Whether a DB instance supports provisioned IOPS.
 * @property supportsPerformanceInsights Whether a DB instance supports Performance Insights.
 * @property supportsStorageEncryption Whether a DB instance supports encrypted storage.
 * @property vpc
 */
public data class GetOrderableDbInstanceResult(
    public val availabilityZones: List<String>,
    public val engine: String? = null,
    public val engineVersion: String,
    public val id: String,
    public val instanceClass: String,
    public val licenseModel: String? = null,
    public val maxIopsPerDbInstance: Int,
    public val maxIopsPerGib: Double,
    public val maxStorageSize: Int,
    public val minIopsPerDbInstance: Int,
    public val minIopsPerGib: Double,
    public val minStorageSize: Int,
    public val multiAzCapable: Boolean,
    public val preferredInstanceClasses: List<String>? = null,
    public val readReplicaCapable: Boolean,
    public val storageType: String,
    public val supportsEnhancedMonitoring: Boolean,
    public val supportsIamDatabaseAuthentication: Boolean,
    public val supportsIops: Boolean,
    public val supportsPerformanceInsights: Boolean,
    public val supportsStorageEncryption: Boolean,
    public val vpc: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.neptune.outputs.GetOrderableDbInstanceResult):
            GetOrderableDbInstanceResult = GetOrderableDbInstanceResult(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            licenseModel = javaType.licenseModel().map({ args0 -> args0 }).orElse(null),
            maxIopsPerDbInstance = javaType.maxIopsPerDbInstance(),
            maxIopsPerGib = javaType.maxIopsPerGib(),
            maxStorageSize = javaType.maxStorageSize(),
            minIopsPerDbInstance = javaType.minIopsPerDbInstance(),
            minIopsPerGib = javaType.minIopsPerGib(),
            minStorageSize = javaType.minStorageSize(),
            multiAzCapable = javaType.multiAzCapable(),
            preferredInstanceClasses = javaType.preferredInstanceClasses().map({ args0 -> args0 }),
            readReplicaCapable = javaType.readReplicaCapable(),
            storageType = javaType.storageType(),
            supportsEnhancedMonitoring = javaType.supportsEnhancedMonitoring(),
            supportsIamDatabaseAuthentication = javaType.supportsIamDatabaseAuthentication(),
            supportsIops = javaType.supportsIops(),
            supportsPerformanceInsights = javaType.supportsPerformanceInsights(),
            supportsStorageEncryption = javaType.supportsStorageEncryption(),
            vpc = javaType.vpc(),
        )
    }
}
