@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.LoggingConfigurationLoggingConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.LoggingConfigurationLoggingConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoggingConfiguration].
 */
@PulumiTagMarker
public class LoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingConfigurationArgs = LoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = LoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LoggingConfiguration {
        val builtJavaResource =
            com.pulumi.aws.networkfirewall.LoggingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoggingConfiguration(builtJavaResource)
    }
}

/**
 * Provides an AWS Network Firewall Logging Configuration Resource
 * ## Example Usage
 * ### Logging to S3
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.ofEntries(
 *                         Map.entry("bucketName", aws_s3_bucket.example().bucket()),
 *                         Map.entry("prefix", "/example")
 *                     ))
 *                     .logDestinationType("S3")
 *                     .logType("FLOW")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging to CloudWatch
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("logGroup", aws_cloudwatch_log_group.example().name()))
 *                     .logDestinationType("CloudWatchLogs")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging to Kinesis Data Firehose
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("deliveryStream", aws_kinesis_firehose_delivery_stream.example().name()))
 *                     .logDestinationType("KinesisDataFirehose")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:
 * ```sh
 *  $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 *
 */
public class LoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.LoggingConfiguration,
) : KotlinCustomResource(javaResource, LoggingConfigurationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    public val firewallArn: Output<String>
        get() = javaResource.firewallArn().applyValue({ args0 -> args0 })

    /**
     * A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    public val loggingConfiguration: Output<LoggingConfigurationLoggingConfiguration>
        get() = javaResource.loggingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object LoggingConfigurationMapper : ResourceMapper<LoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.LoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): LoggingConfiguration = LoggingConfiguration(
        javaResource
            as com.pulumi.aws.networkfirewall.LoggingConfiguration,
    )
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoggingConfiguration].
 */
public suspend fun loggingConfiguration(
    name: String,
    block: suspend LoggingConfigurationResourceBuilder.() -> Unit,
): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loggingConfiguration(name: String): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
