@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.LoggingConfigurationLoggingConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.LoggingConfigurationLoggingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an AWS Network Firewall Logging Configuration Resource
 * ## Example Usage
 * ### Logging to S3
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.ofEntries(
 *                         Map.entry("bucketName", aws_s3_bucket.example().bucket()),
 *                         Map.entry("prefix", "/example")
 *                     ))
 *                     .logDestinationType("S3")
 *                     .logType("FLOW")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging to CloudWatch
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("logGroup", aws_cloudwatch_log_group.example().name()))
 *                     .logDestinationType("CloudWatchLogs")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging to Kinesis Data Firehose
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration("example", LoggingConfigurationArgs.builder()
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of("deliveryStream", aws_kinesis_firehose_delivery_stream.example().name()))
 *                     .logDestinationType("KinesisDataFirehose")
 *                     .logType("ALERT")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:
 * ```sh
 *  $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 * @property firewallArn The Amazon Resource Name (ARN) of the Network Firewall firewall.
 * @property loggingConfiguration A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
 */
public data class LoggingConfigurationArgs(
    public val firewallArn: Output<String>? = null,
    public val loggingConfiguration: Output<LoggingConfigurationLoggingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.LoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.LoggingConfigurationArgs =
        com.pulumi.aws.networkfirewall.LoggingConfigurationArgs.builder()
            .firewallArn(firewallArn?.applyValue({ args0 -> args0 }))
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingConfigurationArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationArgsBuilder internal constructor() {
    private var firewallArn: Output<String>? = null

    private var loggingConfiguration: Output<LoggingConfigurationLoggingConfigurationArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    @JvmName("dwupeujheplycwag")
    public suspend fun firewallArn(`value`: Output<String>) {
        this.firewallArn = value
    }

    /**
     * @param value A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("ftxjeyljerryptpb")
    public suspend
    fun loggingConfiguration(`value`: Output<LoggingConfigurationLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Firewall firewall.
     */
    @JvmName("crcbajudroyissde")
    public suspend fun firewallArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallArn = mapped
    }

    /**
     * @param value A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("tdlwmoaihigjttnv")
    public suspend fun loggingConfiguration(`value`: LoggingConfigurationLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     */
    @JvmName("hymxhsuinrkowexp")
    public suspend
    fun loggingConfiguration(argument: suspend LoggingConfigurationLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingConfigurationLoggingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    internal fun build(): LoggingConfigurationArgs = LoggingConfigurationArgs(
        firewallArn = firewallArn,
        loggingConfiguration = loggingConfiguration,
    )
}
