@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getFirewallPlain
import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getFirewallPolicyPlain
import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions.getResourcePolicyPlain
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPolicyPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetFirewallPolicyPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetResourcePolicyPlainArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.GetResourcePolicyPlainArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyResult
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallResult
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetResourcePolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyResult.Companion.toKotlin as getFirewallPolicyResultToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallResult.Companion.toKotlin as getFirewallResultToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.GetResourcePolicyResult.Companion.toKotlin as getResourcePolicyResultToKotlin

public object NetworkfirewallFunctions {
    /**
     * Retrieve information about a firewall.
     * ## Example Usage
     * ### Find firewall policy by ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .arn(aws_networkfirewall_firewall.arn())
     *             .build());
     *     }
     * }
     * ```
     * ### Find firewall policy by Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * ### Find firewall policy by ARN and Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewall(GetFirewallArgs.builder()
     *             .arn(aws_networkfirewall_firewall.arn())
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFirewall.
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(argument: GetFirewallPlainArgs): GetFirewallResult =
        getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())

    /**
     * @see [getFirewall].
     * @param arn ARN of the firewall.
     * @param name Descriptive name of the firewall.
     * @param tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetFirewallResult {
        val argument = GetFirewallPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewall].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetFirewallPlainArgs].
     * @return A collection of values returned by getFirewall.
     */
    public suspend fun getFirewall(argument: suspend GetFirewallPlainArgsBuilder.() -> Unit):
        GetFirewallResult {
        val builder = GetFirewallPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallResultToKotlin(getFirewallPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a firewall policy.
     * ## Example Usage
     * ### Find firewall policy by name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .name(var_.firewall_policy_name())
     *             .build());
     *     }
     * }
     * ```
     * ### Find firewall policy by ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .arn(var_.firewall_policy_arn())
     *             .build());
     *     }
     * }
     * ```
     * ### Find firewall policy by name and ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetFirewallPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getFirewallPolicy(GetFirewallPolicyArgs.builder()
     *             .arn(var_.firewall_policy_arn())
     *             .name(var_.firewall_policy_name())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFirewallPolicy.
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend fun getFirewallPolicy(argument: GetFirewallPolicyPlainArgs):
        GetFirewallPolicyResult =
        getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(argument.toJava()).await())

    /**
     * @see [getFirewallPolicy].
     * @param arn ARN of the firewall policy.
     * @param name Descriptive name of the firewall policy.
     * @param tags Key-value tags for the firewall policy.
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend fun getFirewallPolicy(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetFirewallPolicyResult {
        val argument = GetFirewallPolicyPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetFirewallPolicyPlainArgs].
     * @return A collection of values returned by getFirewallPolicy.
     */
    public suspend
    fun getFirewallPolicy(argument: suspend GetFirewallPolicyPlainArgsBuilder.() -> Unit):
        GetFirewallPolicyResult {
        val builder = GetFirewallPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallPolicyResultToKotlin(getFirewallPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Network Firewall resource policy.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkfirewall.NetworkfirewallFunctions;
     * import com.pulumi.aws.networkfirewall.inputs.GetResourcePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkfirewallFunctions.getResourcePolicy(GetResourcePolicyArgs.builder()
     *             .resourceArn(var_.resource_policy_arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResourcePolicy.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(argument: GetResourcePolicyPlainArgs):
        GetResourcePolicyResult =
        getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())

    /**
     * @see [getResourcePolicy].
     * @param resourceArn The Amazon Resource Name (ARN) that identifies the resource policy.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(resourceArn: String): GetResourcePolicyResult {
        val argument = GetResourcePolicyPlainArgs(
            resourceArn = resourceArn,
        )
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourcePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkfirewall&#46;kotlin&#46;inputs&#46;GetResourcePolicyPlainArgs].
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend
    fun getResourcePolicy(argument: suspend GetResourcePolicyPlainArgsBuilder.() -> Unit):
        GetResourcePolicyResult {
        val builder = GetResourcePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(builtArgument.toJava()).await())
    }
}
