@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupEncryptionConfiguration
import com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroup
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupEncryptionConfiguration.Companion.toKotlin as ruleGroupEncryptionConfigurationToKotlin
import com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroup.Companion.toKotlin as ruleGroupRuleGroupToKotlin

/**
 * Builder for [RuleGroup].
 */
@PulumiTagMarker
public class RuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleGroupArgs = RuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleGroupArgsBuilder.() -> Unit) {
        val builder = RuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RuleGroup {
        val builtJavaResource = com.pulumi.aws.networkfirewall.RuleGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleGroup(builtJavaResource)
    }
}

/**
 * Provides an AWS Network Firewall Rule Group Resource
 * ## Example Usage
 * ### Stateful Inspection for denying access to a domain
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesSourceList(RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder()
 *                         .generatedRulesType("DENYLIST")
 *                         .targetTypes("HTTP_HOST")
 *                         .targets("test.example.com")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATEFUL")
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection for permitting packets from a source IP address
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ips =
 *             "1.1.1.1/32",
 *             "1.0.0.1/32";
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(50)
 *             .description("Permits http traffic from source")
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "permit HTTP from source"))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection for blocking packets from going to an intended destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .statefulRule(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATEFUL")
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection from rules specifications defined in Suricata flat format
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .rules(Files.readString(Paths.get("example.rules")))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection from rule group specifications using rule variables and Suricata format rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .ruleVariables(RuleGroupRuleGroupRuleVariablesArgs.builder()
 *                     .ipSets(
 *                         RuleGroupRuleGroupRuleVariablesIpSetArgs.builder()
 *                             .key("WEBSERVERS_HOSTS")
 *                             .ipSet(RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs.builder()
 *                                 .definitions(
 *                                     "10.0.0.0/16",
 *                                     "10.0.1.0/24",
 *                                     "192.168.0.0/16")
 *                                 .build())
 *                             .build(),
 *                         RuleGroupRuleGroupRuleVariablesIpSetArgs.builder()
 *                             .key("EXTERNAL_HOST")
 *                             .ipSet(RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs.builder()
 *                                 .definitions("1.2.3.4/32")
 *                                 .build())
 *                             .build())
 *                     .portSets(RuleGroupRuleGroupRuleVariablesPortSetArgs.builder()
 *                         .key("HTTP_PORTS")
 *                         .portSet(RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs.builder()
 *                             .definitions(
 *                                 "443",
 *                                 "80")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesString(Files.readString(Paths.get("suricata_rules_file")))
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateless Inspection with a Custom Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .description("Stateless Rate Limiting Rule")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .statelessRulesAndCustomActions(RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs.builder()
 *                         .customAction(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .statelessRule(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATELESS")
 *             .build());
 *     }
 * }
 * ```
 * ### IP Set References to the Rule Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesSourceList(RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder()
 *                         .generatedRulesType("DENYLIST")
 *                         .targetTypes("HTTP_HOST")
 *                         .targets("test.example.com")
 *                         .build())
 *                     .build())
 *                 .referenceSets(RuleGroupRuleGroupReferenceSetsArgs.builder()
 *                     .ipSetReferences(RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs.builder()
 *                         .key("example")
 *                         .ipSetReferences(RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs.builder()
 *                             .referenceArn(aws_ec2_managed_prefix_list.this().arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Firewall Rule Groups using their `arn`. For example:
 * ```sh
 *  $ pulumi import aws:networkfirewall/ruleGroup:RuleGroup example arn:aws:network-firewall:us-west-1:123456789012:stateful-rulegroup/example
 * ```
 *
 */
public class RuleGroup internal constructor(
    override val javaResource: com.pulumi.aws.networkfirewall.RuleGroup,
) : KotlinCustomResource(javaResource, RuleGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) that identifies the rule group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * A friendly description of the rule group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    public val encryptionConfiguration: Output<RuleGroupEncryptionConfiguration>?
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ruleGroupEncryptionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A friendly name of the rule group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
     */
    public val ruleGroup: Output<RuleGroupRuleGroup>
        get() = javaResource.ruleGroup().applyValue({ args0 ->
            args0.let({ args0 ->
                ruleGroupRuleGroupToKotlin(args0)
            })
        })

    /**
     * The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
     */
    public val rules: Output<String>?
        get() = javaResource.rules().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A string token used when updating the rule group.
     */
    public val updateToken: Output<String>
        get() = javaResource.updateToken().applyValue({ args0 -> args0 })
}

public object RuleGroupMapper : ResourceMapper<RuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkfirewall.RuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): RuleGroup = RuleGroup(
        javaResource as
            com.pulumi.aws.networkfirewall.RuleGroup,
    )
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleGroup].
 */
public suspend fun ruleGroup(name: String, block: suspend RuleGroupResourceBuilder.() -> Unit):
    RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleGroup(name: String): RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
