@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin

import com.pulumi.aws.networkfirewall.RuleGroupArgs.builder
import com.pulumi.aws.networkfirewall.kotlin.inputs.RuleGroupEncryptionConfigurationArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.RuleGroupEncryptionConfigurationArgsBuilder
import com.pulumi.aws.networkfirewall.kotlin.inputs.RuleGroupRuleGroupArgs
import com.pulumi.aws.networkfirewall.kotlin.inputs.RuleGroupRuleGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Network Firewall Rule Group Resource
 * ## Example Usage
 * ### Stateful Inspection for denying access to a domain
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesSourceList(RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder()
 *                         .generatedRulesType("DENYLIST")
 *                         .targetTypes("HTTP_HOST")
 *                         .targets("test.example.com")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATEFUL")
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection for permitting packets from a source IP address
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ips =
 *             "1.1.1.1/32",
 *             "1.0.0.1/32";
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(50)
 *             .description("Permits http traffic from source")
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "permit HTTP from source"))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection for blocking packets from going to an intended destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .statefulRule(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATEFUL")
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection from rules specifications defined in Suricata flat format
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .rules(Files.readString(Paths.get("example.rules")))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateful Inspection from rule group specifications using rule variables and Suricata format rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .ruleVariables(RuleGroupRuleGroupRuleVariablesArgs.builder()
 *                     .ipSets(
 *                         RuleGroupRuleGroupRuleVariablesIpSetArgs.builder()
 *                             .key("WEBSERVERS_HOSTS")
 *                             .ipSet(RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs.builder()
 *                                 .definitions(
 *                                     "10.0.0.0/16",
 *                                     "10.0.1.0/24",
 *                                     "192.168.0.0/16")
 *                                 .build())
 *                             .build(),
 *                         RuleGroupRuleGroupRuleVariablesIpSetArgs.builder()
 *                             .key("EXTERNAL_HOST")
 *                             .ipSet(RuleGroupRuleGroupRuleVariablesIpSetIpSetArgs.builder()
 *                                 .definitions("1.2.3.4/32")
 *                                 .build())
 *                             .build())
 *                     .portSets(RuleGroupRuleGroupRuleVariablesPortSetArgs.builder()
 *                         .key("HTTP_PORTS")
 *                         .portSet(RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs.builder()
 *                             .definitions(
 *                                 "443",
 *                                 "80")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesString(Files.readString(Paths.get("suricata_rules_file")))
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Stateless Inspection with a Custom Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .description("Stateless Rate Limiting Rule")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .statelessRulesAndCustomActions(RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs.builder()
 *                         .customAction(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .statelessRule(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .type("STATELESS")
 *             .build());
 *     }
 * }
 * ```
 * ### IP Set References to the Rule Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.RuleGroup;
 * import com.pulumi.aws.networkfirewall.RuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs;
 * import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RuleGroup("example", RuleGroupArgs.builder()
 *             .capacity(100)
 *             .type("STATEFUL")
 *             .ruleGroup(RuleGroupRuleGroupArgs.builder()
 *                 .rulesSource(RuleGroupRuleGroupRulesSourceArgs.builder()
 *                     .rulesSourceList(RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder()
 *                         .generatedRulesType("DENYLIST")
 *                         .targetTypes("HTTP_HOST")
 *                         .targets("test.example.com")
 *                         .build())
 *                     .build())
 *                 .referenceSets(RuleGroupRuleGroupReferenceSetsArgs.builder()
 *                     .ipSetReferences(RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs.builder()
 *                         .key("example")
 *                         .ipSetReferences(RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs.builder()
 *                             .referenceArn(aws_ec2_managed_prefix_list.this().arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Firewall Rule Groups using their `arn`. For example:
 * ```sh
 *  $ pulumi import aws:networkfirewall/ruleGroup:RuleGroup example arn:aws:network-firewall:us-west-1:123456789012:stateful-rulegroup/example
 * ```
 * @property capacity The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
 * @property description A friendly description of the rule group.
 * @property encryptionConfiguration KMS encryption configuration settings. See Encryption Configuration below for details.
 * @property name A friendly name of the rule group.
 * @property ruleGroup A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
 * @property rules The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
 * @property tags A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
 */
public data class RuleGroupArgs(
    public val capacity: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val encryptionConfiguration: Output<RuleGroupEncryptionConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val ruleGroup: Output<RuleGroupRuleGroupArgs>? = null,
    public val rules: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.RuleGroupArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.RuleGroupArgs =
        com.pulumi.aws.networkfirewall.RuleGroupArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleGroup(ruleGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rules(rules?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupArgs].
 */
@PulumiTagMarker
public class RuleGroupArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var description: Output<String>? = null

    private var encryptionConfiguration: Output<RuleGroupEncryptionConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var ruleGroup: Output<RuleGroupRuleGroupArgs>? = null

    private var rules: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
     */
    @JvmName("rhyhvapdgkujfaxj")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value A friendly description of the rule group.
     */
    @JvmName("iisjwboatpuajhli")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("oxvxxxfmnxcbkahx")
    public suspend
    fun encryptionConfiguration(`value`: Output<RuleGroupEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("ygaaxcjginefmjpu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
     */
    @JvmName("sgvvcuejedlfpopd")
    public suspend fun ruleGroup(`value`: Output<RuleGroupRuleGroupArgs>) {
        this.ruleGroup = value
    }

    /**
     * @param value The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
     */
    @JvmName("stbwgwwbxkfpdacp")
    public suspend fun rules(`value`: Output<String>) {
        this.rules = value
    }

    /**
     * @param value A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("isjajmdtrodmwuau")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
     */
    @JvmName("xqsohwmfpjjucwxd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
     */
    @JvmName("asaqlqrdyrrwjgwv")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value A friendly description of the rule group.
     */
    @JvmName("uhexoamgptdcfogr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("pdkhyrcgamgylenh")
    public suspend fun encryptionConfiguration(`value`: RuleGroupEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument KMS encryption configuration settings. See Encryption Configuration below for details.
     */
    @JvmName("jyrpkvkxvhwwkcgc")
    public suspend
    fun encryptionConfiguration(argument: suspend RuleGroupEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("bidoomwbvuqbvwbm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
     */
    @JvmName("xrwmgdcfggugscdd")
    public suspend fun ruleGroup(`value`: RuleGroupRuleGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroup = mapped
    }

    /**
     * @param argument A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
     */
    @JvmName("hwmqaekyxsuxfkqf")
    public suspend fun ruleGroup(argument: suspend RuleGroupRuleGroupArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleGroup = mapped
    }

    /**
     * @param value The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
     */
    @JvmName("gfbumgnwnpdypcub")
    public suspend fun rules(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vvlqoacbtpvkakst")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqnegokbsfdxwkga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
     */
    @JvmName("faseuhkqhdybllgl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleGroupArgs = RuleGroupArgs(
        capacity = capacity,
        description = description,
        encryptionConfiguration = encryptionConfiguration,
        name = name,
        ruleGroup = ruleGroup,
        rules = rules,
        tags = tags,
        type = type,
    )
}
