@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ruleOrder Indicates how to manage the order of stateful rule evaluation for the policy. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
 * @property streamExceptionPolicy Describes how to treat traffic which has broken midstream. Default value: `DROP`. Valid values: `DROP`, `CONTINUE`, `REJECT`.
 */
public data class FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs(
    public val ruleOrder: Output<String>? = null,
    public val streamExceptionPolicy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs.builder()
            .ruleOrder(ruleOrder?.applyValue({ args0 -> args0 }))
            .streamExceptionPolicy(streamExceptionPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyStatefulEngineOptionsArgsBuilder internal constructor() {
    private var ruleOrder: Output<String>? = null

    private var streamExceptionPolicy: Output<String>? = null

    /**
     * @param value Indicates how to manage the order of stateful rule evaluation for the policy. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
     */
    @JvmName("plvhneldsgxteypq")
    public suspend fun ruleOrder(`value`: Output<String>) {
        this.ruleOrder = value
    }

    /**
     * @param value Describes how to treat traffic which has broken midstream. Default value: `DROP`. Valid values: `DROP`, `CONTINUE`, `REJECT`.
     */
    @JvmName("mvyfmyvqjmdyefen")
    public suspend fun streamExceptionPolicy(`value`: Output<String>) {
        this.streamExceptionPolicy = value
    }

    /**
     * @param value Indicates how to manage the order of stateful rule evaluation for the policy. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
     */
    @JvmName("lviinmpmsgysihvn")
    public suspend fun ruleOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleOrder = mapped
    }

    /**
     * @param value Describes how to treat traffic which has broken midstream. Default value: `DROP`. Valid values: `DROP`, `CONTINUE`, `REJECT`.
     */
    @JvmName("osekwoabwsgjasbq")
    public suspend fun streamExceptionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamExceptionPolicy = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs =
        FirewallPolicyFirewallPolicyStatefulEngineOptionsArgs(
            ruleOrder = ruleOrder,
            streamExceptionPolicy = streamExceptionPolicy,
        )
}
