@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property override Configuration block for override values
 * @property priority An integer setting that indicates the order in which to apply the stateful rule groups in a single policy. This argument must be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. AWS Network Firewall applies each stateful rule group to a packet starting with the group that has the lowest priority setting.
 * @property resourceArn The Amazon Resource Name (ARN) of the stateful rule group.
 */
public data class FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs(
    public val `override`: Output<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs>? =
        null,
    public val priority: Output<Int>? = null,
    public val resourceArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs.builder()
            .`override`(`override`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgsBuilder internal
constructor() {
    private var `override`:
        Output<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs>? = null

    private var priority: Output<Int>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value Configuration block for override values
     */
    @JvmName("xgbitciondmgakkp")
    public suspend
    fun `override`(`value`: Output<FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs>) {
        this.`override` = value
    }

    /**
     * @param value An integer setting that indicates the order in which to apply the stateful rule groups in a single policy. This argument must be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. AWS Network Firewall applies each stateful rule group to a packet starting with the group that has the lowest priority setting.
     */
    @JvmName("sgjcbahoxskeiqmg")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the stateful rule group.
     */
    @JvmName("sccqrbesswirwvhf")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Configuration block for override values
     */
    @JvmName("ybovtkodyooxgivi")
    public suspend
    fun `override`(`value`: FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param argument Configuration block for override values
     */
    @JvmName("gdrxdlldjlixuvqt")
    public suspend
    fun `override`(argument: suspend FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`override` = mapped
    }

    /**
     * @param value An integer setting that indicates the order in which to apply the stateful rule groups in a single policy. This argument must be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. AWS Network Firewall applies each stateful rule group to a packet starting with the group that has the lowest priority setting.
     */
    @JvmName("lecjudjlecmohewb")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the stateful rule group.
     */
    @JvmName("mnpusqkioyugqweq")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs =
        FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceArgs(
            `override` = `override`,
            priority = priority,
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
        )
}
