@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action The action that changes the rule group from DROP to ALERT . This only applies to managed rule groups.
 */
public data class FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs(
    public val action: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs.builder()
            .action(action?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgsBuilder internal
constructor() {
    private var action: Output<String>? = null

    /**
     * @param value The action that changes the rule group from DROP to ALERT . This only applies to managed rule groups.
     */
    @JvmName("jgowffaoxcdeukcc")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The action that changes the rule group from DROP to ALERT . This only applies to managed rule groups.
     */
    @JvmName("jaqcbglyjasovuec")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs =
        FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverrideArgs(
            action = action,
        )
}
