@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property publishMetricAction A configuration block describing the stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. You can pair this custom action with any of the standard stateless rule actions. See Publish Metric Action below for details.
 */
public data class FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs(
    public val publishMetricAction:
    Output<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs.builder()
            .publishMetricAction(
                publishMetricAction.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgsBuilder internal
constructor() {
    private var publishMetricAction:
        Output<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs>? =
        null

    /**
     * @param value A configuration block describing the stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. You can pair this custom action with any of the standard stateless rule actions. See Publish Metric Action below for details.
     */
    @JvmName("uduuvneghjklhqod")
    public suspend
    fun publishMetricAction(`value`: Output<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs>) {
        this.publishMetricAction = value
    }

    /**
     * @param value A configuration block describing the stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. You can pair this custom action with any of the standard stateless rule actions. See Publish Metric Action below for details.
     */
    @JvmName("puadmvpdpowmrvgd")
    public suspend
    fun publishMetricAction(`value`: FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publishMetricAction = mapped
    }

    /**
     * @param argument A configuration block describing the stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. You can pair this custom action with any of the standard stateless rule actions. See Publish Metric Action below for details.
     */
    @JvmName("llacnmkondiwkosy")
    public suspend
    fun publishMetricAction(argument: suspend FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.publishMetricAction = mapped
    }

    internal fun build(): FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs =
        FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionArgs(
            publishMetricAction = publishMetricAction ?: throw PulumiNullFieldException("publishMetricAction"),
        )
}
