@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
 */
public data class
FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs(
    public val dimensions:
    Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs =
        com.pulumi.aws.networkfirewall.inputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs.builder()
            .dimensions(
                dimensions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs].
 */
@PulumiTagMarker
public class
FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgsBuilder
internal constructor() {
    private var dimensions:
        Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>>? =
        null

    /**
     * @param value Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("kogmmqpuwqtperxk")
    public suspend
    fun dimensions(`value`: Output<List<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("kigctardidcybuen")
    public suspend fun dimensions(
        vararg
        values: Output<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>,
    ) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("vpaprmhpeoftbisi")
    public suspend
    fun dimensions(values: List<Output<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("mbkqsmkbutlhunad")
    public suspend
    fun dimensions(`value`: List<FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("slhqgncfodarmxna")
    public suspend
    fun dimensions(argument: List<suspend FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("qfqcfiqnsggcjxny")
    public suspend fun dimensions(
        vararg
        argument: suspend FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("rmqctwpayonevwwv")
    public suspend
    fun dimensions(argument: suspend FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Set of configuration blocks describing dimension settings to use for Amazon CloudWatch custom metrics. See Dimension below for more details.
     */
    @JvmName("rqirysobxqhprguj")
    public suspend fun dimensions(
        vararg
        values: FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionDimensionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    internal fun build():
        FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs =
        FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinitionPublishMetricActionArgs(
            dimensions = dimensions ?: throw PulumiNullFieldException("dimensions"),
        )
}
