@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.GetFirewallPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFirewall.
 * @property arn ARN of the firewall.
 * @property name Descriptive name of the firewall.
 * @property tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class GetFirewallPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.GetFirewallPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.GetFirewallPlainArgs =
        com.pulumi.aws.networkfirewall.inputs.GetFirewallPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetFirewallPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the firewall.
     */
    @JvmName("spgpeeobjqhgxkci")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Descriptive name of the firewall.
     */
    @JvmName("itjduwtggvqxgqid")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tiqkwgkiqdmitqrm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tyyafmqiygaljcch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetFirewallPlainArgs = GetFirewallPlainArgs(
        arn = arn,
        name = name,
        tags = tags,
    )
}
