@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property logDestination A map describing the logging destination for the chosen `log_destination_type`.
 * * For an Amazon S3 bucket, specify the key `bucketName` with the name of the bucket and optionally specify the key `prefix` with a path.
 * * For a CloudWatch log group, specify the key `logGroup` with the name of the CloudWatch log group.
 * * For a Kinesis Data Firehose delivery stream, specify the key `deliveryStream` with the name of the delivery stream.
 * @property logDestinationType The location to send logs to. Valid values: `S3`, `CloudWatchLogs`, `KinesisDataFirehose`.
 * @property logType The type of log to send. Valid values: `ALERT` or `FLOW`. Alert logs report traffic that matches a `StatefulRule` with an action setting that sends a log message. Flow logs are standard network traffic flow logs.
 */
public data class LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
    public val logDestination: Output<Map<String, String>>,
    public val logDestinationType: Output<String>,
    public val logType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs =
        com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
            .logDestination(
                logDestination.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .logDestinationType(logDestinationType.applyValue({ args0 -> args0 }))
            .logType(logType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationLoggingConfigurationLogDestinationConfigArgsBuilder internal
constructor() {
    private var logDestination: Output<Map<String, String>>? = null

    private var logDestinationType: Output<String>? = null

    private var logType: Output<String>? = null

    /**
     * @param value A map describing the logging destination for the chosen `log_destination_type`.
     * * For an Amazon S3 bucket, specify the key `bucketName` with the name of the bucket and optionally specify the key `prefix` with a path.
     * * For a CloudWatch log group, specify the key `logGroup` with the name of the CloudWatch log group.
     * * For a Kinesis Data Firehose delivery stream, specify the key `deliveryStream` with the name of the delivery stream.
     */
    @JvmName("ahdwqfhhpgpcbebn")
    public suspend fun logDestination(`value`: Output<Map<String, String>>) {
        this.logDestination = value
    }

    /**
     * @param value The location to send logs to. Valid values: `S3`, `CloudWatchLogs`, `KinesisDataFirehose`.
     */
    @JvmName("ufkbeetjdutmijtr")
    public suspend fun logDestinationType(`value`: Output<String>) {
        this.logDestinationType = value
    }

    /**
     * @param value The type of log to send. Valid values: `ALERT` or `FLOW`. Alert logs report traffic that matches a `StatefulRule` with an action setting that sends a log message. Flow logs are standard network traffic flow logs.
     */
    @JvmName("yosworojxqytpqwv")
    public suspend fun logType(`value`: Output<String>) {
        this.logType = value
    }

    /**
     * @param value A map describing the logging destination for the chosen `log_destination_type`.
     * * For an Amazon S3 bucket, specify the key `bucketName` with the name of the bucket and optionally specify the key `prefix` with a path.
     * * For a CloudWatch log group, specify the key `logGroup` with the name of the CloudWatch log group.
     * * For a Kinesis Data Firehose delivery stream, specify the key `deliveryStream` with the name of the delivery stream.
     */
    @JvmName("ojgbcggfgedrwdgs")
    public suspend fun logDestination(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param values A map describing the logging destination for the chosen `log_destination_type`.
     * * For an Amazon S3 bucket, specify the key `bucketName` with the name of the bucket and optionally specify the key `prefix` with a path.
     * * For a CloudWatch log group, specify the key `logGroup` with the name of the CloudWatch log group.
     * * For a Kinesis Data Firehose delivery stream, specify the key `deliveryStream` with the name of the delivery stream.
     */
    @JvmName("fodluvruaxnskiah")
    public fun logDestination(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value The location to send logs to. Valid values: `S3`, `CloudWatchLogs`, `KinesisDataFirehose`.
     */
    @JvmName("ehcmqsihnbfbhgeh")
    public suspend fun logDestinationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestinationType = mapped
    }

    /**
     * @param value The type of log to send. Valid values: `ALERT` or `FLOW`. Alert logs report traffic that matches a `StatefulRule` with an action setting that sends a log message. Flow logs are standard network traffic flow logs.
     */
    @JvmName("sjnmtmrgdhkranca")
    public suspend fun logType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    internal fun build(): LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs =
        LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
            logDestination = logDestination ?: throw PulumiNullFieldException("logDestination"),
            logDestinationType = logDestinationType ?: throw PulumiNullFieldException("logDestinationType"),
            logType = logType ?: throw PulumiNullFieldException("logType"),
        )
}
