@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property referenceSets A configuration block that defines the IP Set References for the rule group. See Reference Sets below for details. Please notes that there can only be a maximum of 5 `reference_sets` in a `rule_group`. See the [AWS documentation](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-ip-set-reference-limits) for details.
 * @property ruleVariables A configuration block that defines additional settings available to use in the rules defined in the rule group. Can only be specified for **stateful** rule groups. See Rule Variables below for details.
 * @property rulesSource A configuration block that defines the stateful or stateless rules for the rule group. See Rules Source below for details.
 * @property statefulRuleOptions A configuration block that defines stateful rule options for the rule group. See Stateful Rule Options below for details.
 */
public data class RuleGroupRuleGroupArgs(
    public val referenceSets: Output<RuleGroupRuleGroupReferenceSetsArgs>? = null,
    public val ruleVariables: Output<RuleGroupRuleGroupRuleVariablesArgs>? = null,
    public val rulesSource: Output<RuleGroupRuleGroupRulesSourceArgs>,
    public val statefulRuleOptions: Output<RuleGroupRuleGroupStatefulRuleOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupArgs.builder()
            .referenceSets(referenceSets?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleVariables(ruleVariables?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rulesSource(rulesSource.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .statefulRuleOptions(
                statefulRuleOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupArgsBuilder internal constructor() {
    private var referenceSets: Output<RuleGroupRuleGroupReferenceSetsArgs>? = null

    private var ruleVariables: Output<RuleGroupRuleGroupRuleVariablesArgs>? = null

    private var rulesSource: Output<RuleGroupRuleGroupRulesSourceArgs>? = null

    private var statefulRuleOptions: Output<RuleGroupRuleGroupStatefulRuleOptionsArgs>? = null

    /**
     * @param value A configuration block that defines the IP Set References for the rule group. See Reference Sets below for details. Please notes that there can only be a maximum of 5 `reference_sets` in a `rule_group`. See the [AWS documentation](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-ip-set-reference-limits) for details.
     */
    @JvmName("bqcwxlgthyyktnvw")
    public suspend fun referenceSets(`value`: Output<RuleGroupRuleGroupReferenceSetsArgs>) {
        this.referenceSets = value
    }

    /**
     * @param value A configuration block that defines additional settings available to use in the rules defined in the rule group. Can only be specified for **stateful** rule groups. See Rule Variables below for details.
     */
    @JvmName("mlaflhmtsykidwjl")
    public suspend fun ruleVariables(`value`: Output<RuleGroupRuleGroupRuleVariablesArgs>) {
        this.ruleVariables = value
    }

    /**
     * @param value A configuration block that defines the stateful or stateless rules for the rule group. See Rules Source below for details.
     */
    @JvmName("yoambfelvpslbtwn")
    public suspend fun rulesSource(`value`: Output<RuleGroupRuleGroupRulesSourceArgs>) {
        this.rulesSource = value
    }

    /**
     * @param value A configuration block that defines stateful rule options for the rule group. See Stateful Rule Options below for details.
     */
    @JvmName("jlehpnscxempntte")
    public suspend
    fun statefulRuleOptions(`value`: Output<RuleGroupRuleGroupStatefulRuleOptionsArgs>) {
        this.statefulRuleOptions = value
    }

    /**
     * @param value A configuration block that defines the IP Set References for the rule group. See Reference Sets below for details. Please notes that there can only be a maximum of 5 `reference_sets` in a `rule_group`. See the [AWS documentation](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-ip-set-reference-limits) for details.
     */
    @JvmName("fiajvfrgpimeamrt")
    public suspend fun referenceSets(`value`: RuleGroupRuleGroupReferenceSetsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceSets = mapped
    }

    /**
     * @param argument A configuration block that defines the IP Set References for the rule group. See Reference Sets below for details. Please notes that there can only be a maximum of 5 `reference_sets` in a `rule_group`. See the [AWS documentation](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-ip-set-reference-limits) for details.
     */
    @JvmName("siqiuxtmqlkuvjot")
    public suspend
    fun referenceSets(argument: suspend RuleGroupRuleGroupReferenceSetsArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupReferenceSetsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referenceSets = mapped
    }

    /**
     * @param value A configuration block that defines additional settings available to use in the rules defined in the rule group. Can only be specified for **stateful** rule groups. See Rule Variables below for details.
     */
    @JvmName("mmcmldmlhpiyfchr")
    public suspend fun ruleVariables(`value`: RuleGroupRuleGroupRuleVariablesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleVariables = mapped
    }

    /**
     * @param argument A configuration block that defines additional settings available to use in the rules defined in the rule group. Can only be specified for **stateful** rule groups. See Rule Variables below for details.
     */
    @JvmName("iprspnaunxrjntnp")
    public suspend
    fun ruleVariables(argument: suspend RuleGroupRuleGroupRuleVariablesArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRuleVariablesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleVariables = mapped
    }

    /**
     * @param value A configuration block that defines the stateful or stateless rules for the rule group. See Rules Source below for details.
     */
    @JvmName("cnuaqubykeyjdbnk")
    public suspend fun rulesSource(`value`: RuleGroupRuleGroupRulesSourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesSource = mapped
    }

    /**
     * @param argument A configuration block that defines the stateful or stateless rules for the rule group. See Rules Source below for details.
     */
    @JvmName("sgvhsdfhvdniuvfv")
    public suspend
    fun rulesSource(argument: suspend RuleGroupRuleGroupRulesSourceArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRulesSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rulesSource = mapped
    }

    /**
     * @param value A configuration block that defines stateful rule options for the rule group. See Stateful Rule Options below for details.
     */
    @JvmName("pvvmrxkiftxhgqjh")
    public suspend fun statefulRuleOptions(`value`: RuleGroupRuleGroupStatefulRuleOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulRuleOptions = mapped
    }

    /**
     * @param argument A configuration block that defines stateful rule options for the rule group. See Stateful Rule Options below for details.
     */
    @JvmName("bcodoxmafbmomrui")
    public suspend
    fun statefulRuleOptions(argument: suspend RuleGroupRuleGroupStatefulRuleOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupStatefulRuleOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.statefulRuleOptions = mapped
    }

    internal fun build(): RuleGroupRuleGroupArgs = RuleGroupRuleGroupArgs(
        referenceSets = referenceSets,
        ruleVariables = ruleVariables,
        rulesSource = rulesSource ?: throw PulumiNullFieldException("rulesSource"),
        statefulRuleOptions = statefulRuleOptions,
    )
}
