@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ipSetReferences Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
 * @property key A unique alphanumeric string to identify the `ip_set`.
 */
public data class RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs(
    public val ipSetReferences:
    Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>>,
    public val key: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs.builder()
            .ipSetReferences(
                ipSetReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupReferenceSetsIpSetReferenceArgsBuilder internal constructor() {
    private var ipSetReferences:
        Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>>? = null

    private var key: Output<String>? = null

    /**
     * @param value Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("wfuethfwqjmegkyf")
    public suspend
    fun ipSetReferences(`value`: Output<List<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>>) {
        this.ipSetReferences = value
    }

    @JvmName("dkdlpuseqvgqpobf")
    public suspend fun ipSetReferences(
        vararg
        values: Output<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>,
    ) {
        this.ipSetReferences = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("ymbmvasukffjwrkw")
    public suspend
    fun ipSetReferences(values: List<Output<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>>) {
        this.ipSetReferences = Output.all(values)
    }

    /**
     * @param value A unique alphanumeric string to identify the `ip_set`.
     */
    @JvmName("gyaljstwuhyglrdh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("rvwgvfgnkvuottsc")
    public suspend
    fun ipSetReferences(`value`: List<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSetReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("tklupyhkcrkspfsa")
    public suspend
    fun ipSetReferences(argument: List<suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("klfqgfekstjxjatf")
    public suspend fun ipSetReferences(
        vararg
        argument: suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param argument Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("iyaliueglieacpbd")
    public suspend
    fun ipSetReferences(argument: suspend RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.ipSetReferences = mapped
    }

    /**
     * @param values Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
     */
    @JvmName("xbhasvffgqtnxxwj")
    public suspend fun ipSetReferences(
        vararg
        values: RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSetReferences = mapped
    }

    /**
     * @param value A unique alphanumeric string to identify the `ip_set`.
     */
    @JvmName("xiephhdpuqifbjea")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs =
        RuleGroupRuleGroupReferenceSetsIpSetReferenceArgs(
            ipSetReferences = ipSetReferences ?: throw PulumiNullFieldException("ipSetReferences"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
