@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property key An unique alphanumeric string to identify the `port_set`.
 * @property portSet A configuration block that defines a set of port ranges. See Port Set below for details.
 */
public data class RuleGroupRuleGroupRuleVariablesPortSetArgs(
    public val key: Output<String>,
    public val portSet: Output<RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRuleVariablesPortSetArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .portSet(portSet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRuleVariablesPortSetArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRuleVariablesPortSetArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var portSet: Output<RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs>? = null

    /**
     * @param value An unique alphanumeric string to identify the `port_set`.
     */
    @JvmName("ldqpxgjgffydcyjd")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A configuration block that defines a set of port ranges. See Port Set below for details.
     */
    @JvmName("bnavojcdsvhgnxgg")
    public suspend fun portSet(`value`: Output<RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs>) {
        this.portSet = value
    }

    /**
     * @param value An unique alphanumeric string to identify the `port_set`.
     */
    @JvmName("gbqpepbshcpkqael")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A configuration block that defines a set of port ranges. See Port Set below for details.
     */
    @JvmName("rculoqcpgtwlfwuw")
    public suspend fun portSet(`value`: RuleGroupRuleGroupRuleVariablesPortSetPortSetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portSet = mapped
    }

    /**
     * @param argument A configuration block that defines a set of port ranges. See Port Set below for details.
     */
    @JvmName("rrxvjdjiedhfuvph")
    public suspend
    fun portSet(argument: suspend RuleGroupRuleGroupRuleVariablesPortSetPortSetArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRuleVariablesPortSetPortSetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.portSet = mapped
    }

    internal fun build(): RuleGroupRuleGroupRuleVariablesPortSetArgs =
        RuleGroupRuleGroupRuleVariablesPortSetArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            portSet = portSet ?: throw PulumiNullFieldException("portSet"),
        )
}
