@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property rulesSourceList A configuration block containing **stateful** inspection criteria for a domain list rule group. See Rules Source List below for details.
 * @property rulesString The fully qualified name of a file in an S3 bucket that contains Suricata compatible intrusion preventions system (IPS) rules or the Suricata rules as a string. These rules contain **stateful** inspection criteria and the action to take for traffic that matches the criteria.
 * @property statefulRules Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
 * @property statelessRulesAndCustomActions A configuration block containing **stateless** inspection criteria for a stateless rule group. See Stateless Rules and Custom Actions below for details.
 */
public data class RuleGroupRuleGroupRulesSourceArgs(
    public val rulesSourceList: Output<RuleGroupRuleGroupRulesSourceRulesSourceListArgs>? = null,
    public val rulesString: Output<String>? = null,
    public val statefulRules: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>>? = null,
    public val statelessRulesAndCustomActions:
    Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs> {
    override fun toJava(): com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceArgs.builder()
            .rulesSourceList(rulesSourceList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rulesString(rulesString?.applyValue({ args0 -> args0 }))
            .statefulRules(
                statefulRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statelessRulesAndCustomActions(
                statelessRulesAndCustomActions?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceArgsBuilder internal constructor() {
    private var rulesSourceList: Output<RuleGroupRuleGroupRulesSourceRulesSourceListArgs>? = null

    private var rulesString: Output<String>? = null

    private var statefulRules: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>>? = null

    private var statelessRulesAndCustomActions:
        Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs>? = null

    /**
     * @param value A configuration block containing **stateful** inspection criteria for a domain list rule group. See Rules Source List below for details.
     */
    @JvmName("kwqpaxogpqvqjllu")
    public suspend
    fun rulesSourceList(`value`: Output<RuleGroupRuleGroupRulesSourceRulesSourceListArgs>) {
        this.rulesSourceList = value
    }

    /**
     * @param value The fully qualified name of a file in an S3 bucket that contains Suricata compatible intrusion preventions system (IPS) rules or the Suricata rules as a string. These rules contain **stateful** inspection criteria and the action to take for traffic that matches the criteria.
     */
    @JvmName("bjxdafsskbokyrfh")
    public suspend fun rulesString(`value`: Output<String>) {
        this.rulesString = value
    }

    /**
     * @param value Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("ukfbgvpipryxjblv")
    public suspend
    fun statefulRules(`value`: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>>) {
        this.statefulRules = value
    }

    @JvmName("dlclruuqhlviscws")
    public suspend fun statefulRules(
        vararg
        values: Output<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>,
    ) {
        this.statefulRules = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("iesaygvkgldsqdjo")
    public suspend
    fun statefulRules(values: List<Output<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>>) {
        this.statefulRules = Output.all(values)
    }

    /**
     * @param value A configuration block containing **stateless** inspection criteria for a stateless rule group. See Stateless Rules and Custom Actions below for details.
     */
    @JvmName("jrwlvuciihqfnqex")
    public suspend
    fun statelessRulesAndCustomActions(`value`: Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs>) {
        this.statelessRulesAndCustomActions = value
    }

    /**
     * @param value A configuration block containing **stateful** inspection criteria for a domain list rule group. See Rules Source List below for details.
     */
    @JvmName("oafyasigyjubsdkx")
    public suspend fun rulesSourceList(`value`: RuleGroupRuleGroupRulesSourceRulesSourceListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesSourceList = mapped
    }

    /**
     * @param argument A configuration block containing **stateful** inspection criteria for a domain list rule group. See Rules Source List below for details.
     */
    @JvmName("lxycubrfxclodniy")
    public suspend
    fun rulesSourceList(argument: suspend RuleGroupRuleGroupRulesSourceRulesSourceListArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRulesSourceRulesSourceListArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rulesSourceList = mapped
    }

    /**
     * @param value The fully qualified name of a file in an S3 bucket that contains Suricata compatible intrusion preventions system (IPS) rules or the Suricata rules as a string. These rules contain **stateful** inspection criteria and the action to take for traffic that matches the criteria.
     */
    @JvmName("pgiqngnohutccdwy")
    public suspend fun rulesString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesString = mapped
    }

    /**
     * @param value Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("smnhrvwsdqvsatck")
    public suspend fun statefulRules(`value`: List<RuleGroupRuleGroupRulesSourceStatefulRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statefulRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("fwukvyhxgvodltuo")
    public suspend
    fun statefulRules(argument: List<suspend RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statefulRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("yskgkmvdteljlvoi")
    public suspend fun statefulRules(
        vararg
        argument: suspend RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statefulRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("bgdkiblcfwcyrmuj")
    public suspend
    fun statefulRules(argument: suspend RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statefulRules = mapped
    }

    /**
     * @param values Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
     */
    @JvmName("xvyuigrmmicqyehp")
    public suspend fun statefulRules(vararg values: RuleGroupRuleGroupRulesSourceStatefulRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statefulRules = mapped
    }

    /**
     * @param value A configuration block containing **stateless** inspection criteria for a stateless rule group. See Stateless Rules and Custom Actions below for details.
     */
    @JvmName("yyrucihekqudccgy")
    public suspend
    fun statelessRulesAndCustomActions(`value`: RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statelessRulesAndCustomActions = mapped
    }

    /**
     * @param argument A configuration block containing **stateless** inspection criteria for a stateless rule group. See Stateless Rules and Custom Actions below for details.
     */
    @JvmName("deascumphksuuygi")
    public suspend
    fun statelessRulesAndCustomActions(argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.statelessRulesAndCustomActions = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceArgs = RuleGroupRuleGroupRulesSourceArgs(
        rulesSourceList = rulesSourceList,
        rulesString = rulesString,
        statefulRules = statefulRules,
        statelessRulesAndCustomActions = statelessRulesAndCustomActions,
    )
}
