@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property generatedRulesType String value to specify whether domains in the target list are allowed or denied access. Valid values: `ALLOWLIST`, `DENYLIST`.
 * @property targetTypes Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
 * @property targets Set of domains that you want to inspect for in your traffic flows.
 */
public data class RuleGroupRuleGroupRulesSourceRulesSourceListArgs(
    public val generatedRulesType: Output<String>,
    public val targetTypes: Output<List<String>>,
    public val targets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceRulesSourceListArgs.builder()
            .generatedRulesType(generatedRulesType.applyValue({ args0 -> args0 }))
            .targetTypes(targetTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targets(targets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceRulesSourceListArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceRulesSourceListArgsBuilder internal constructor() {
    private var generatedRulesType: Output<String>? = null

    private var targetTypes: Output<List<String>>? = null

    private var targets: Output<List<String>>? = null

    /**
     * @param value String value to specify whether domains in the target list are allowed or denied access. Valid values: `ALLOWLIST`, `DENYLIST`.
     */
    @JvmName("uevpfswbvqsbydva")
    public suspend fun generatedRulesType(`value`: Output<String>) {
        this.generatedRulesType = value
    }

    /**
     * @param value Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
     */
    @JvmName("kqtcqoadkgfsrrda")
    public suspend fun targetTypes(`value`: Output<List<String>>) {
        this.targetTypes = value
    }

    @JvmName("eatfmljwtlhmdrfs")
    public suspend fun targetTypes(vararg values: Output<String>) {
        this.targetTypes = Output.all(values.asList())
    }

    /**
     * @param values Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
     */
    @JvmName("bkxfbssgqrvacgon")
    public suspend fun targetTypes(values: List<Output<String>>) {
        this.targetTypes = Output.all(values)
    }

    /**
     * @param value Set of domains that you want to inspect for in your traffic flows.
     */
    @JvmName("eeivmwlqqaqbejra")
    public suspend fun targets(`value`: Output<List<String>>) {
        this.targets = value
    }

    @JvmName("yjfsvpekicjxwyoj")
    public suspend fun targets(vararg values: Output<String>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Set of domains that you want to inspect for in your traffic flows.
     */
    @JvmName("qmoqvaofilnatiku")
    public suspend fun targets(values: List<Output<String>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value String value to specify whether domains in the target list are allowed or denied access. Valid values: `ALLOWLIST`, `DENYLIST`.
     */
    @JvmName("gucgjsbepstrwelo")
    public suspend fun generatedRulesType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generatedRulesType = mapped
    }

    /**
     * @param value Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
     */
    @JvmName("kabnrjbynkmparnj")
    public suspend fun targetTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTypes = mapped
    }

    /**
     * @param values Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
     */
    @JvmName("iqgdpvdonwuiytof")
    public suspend fun targetTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTypes = mapped
    }

    /**
     * @param value Set of domains that you want to inspect for in your traffic flows.
     */
    @JvmName("uycjsiwpmmmwxeib")
    public suspend fun targets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param values Set of domains that you want to inspect for in your traffic flows.
     */
    @JvmName("lntytuadmjjwfhul")
    public suspend fun targets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceRulesSourceListArgs =
        RuleGroupRuleGroupRulesSourceRulesSourceListArgs(
            generatedRulesType = generatedRulesType ?: throw PulumiNullFieldException("generatedRulesType"),
            targetTypes = targetTypes ?: throw PulumiNullFieldException("targetTypes"),
            targets = targets ?: throw PulumiNullFieldException("targets"),
        )
}
